package com.ximai.mes.md.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.common.utils.excel.converter.DictionaryConverter;
import com.ximai.common.utils.excel.converter.DictionaryFormat;
import com.ximai.common.utils.excel.converter.StaticDataMappingConverter;
import com.ximai.common.utils.excel.converter.StaticDataMappingFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 供应商对象 md_vendor
 *
 * @date 2022-05-06
 */
@Data
@ApiModel("供应商导入")
public class MdVendorExcelImport
{
    private static final long serialVersionUID = 1L;

    /** 供应商编码 */
    @ExcelProperty("供应商编码")
    private String vendorCode;

    /** 供应商名称 */
    @ExcelProperty("供应商名称")
    private String vendorName;

    /** 供应商简称 */
    @ExcelProperty("供应商简称")
    private String vendorNick;

    /** 供应商英文名称 */
    @ExcelProperty("供应商英文名称")
    private String vendorEn;

    /** 供应商简介 */
    @ExcelProperty("供应商简介")
    private String vendorDes;

    /** 供应商LOGO地址 */
    @ExcelProperty("供应商LOGO地址")
    private String vendorLogo;

    /** 供应商等级 */
    @ExcelProperty(value="供应商等级",converter = DictionaryConverter.class)
    @DictionaryFormat(dictType = "mes_vendor_level")
    private String vendorLevel;

    /** 供应商评分 */
    @ExcelProperty("供应商评分")
    private Long vendorScore;

    /** 供应商地址 */
    @ExcelProperty("供应商地址")
    private String address;

    /** 供应商官网地址 */
    @ExcelProperty("供应商官网地址")
    private String website;

    /** 供应商邮箱地址 */
    @ExcelProperty("供应商邮箱地址")
    private String email;

    /** 供应商电话 */
    @ExcelProperty("供应商电话")
    private String tel;

    /** 联系人1 */
    @ExcelProperty("联系人1")
    private String contact1;

    /** 联系人1-电话 */
    @ExcelProperty("联系人1-电话")
    private String contact1Tel;

    /** 联系人1-邮箱 */
    @ExcelProperty("联系人1-邮箱")
    private String contact1Email;

    /** 联系人2 */
    @ExcelProperty("联系人2")
    private String contact2;

    /** 联系人2-电话 */
    @ExcelProperty("联系人2-电话")
    private String contact2Tel;

    /** 联系人2-邮箱 */
    @ExcelProperty("联系人2-邮箱")
    private String contact2Email;

    /** 统一社会信用代码 */
    @ExcelProperty("统一社会信用代码")
    private String creditCode;

    /** 是否启用 */
    @ExcelProperty(value="是否启用", converter = StaticDataMappingConverter.class)
    @StaticDataMappingFormat(value = {"Y","N"},excelValue = {"是","否"})
    private String enableFlag;
}
