package com.ximai.mes.md.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 派车记录对象 md_vehicle_dispatch
 *
 * @author generator
 * @date 2024-01-25
 */
public class MdVehicleDispatch extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /**  */
    @TableId
    private Long dispatchId;

    /** 派车编号 */
    @Excel(name = "派车编号")
    private String dispatchCode;

    /** 名称 */
    @Excel(name = "名称")
    private String dispatchTitle;

    /**  */
    @Excel(name = "")
    private Long vehicleId;

    /** 派车人 */
    @Excel(name = "派车人")
    private String dispatchBy;

    /** 驾驶人 */
    @Excel(name = "驾驶人")
    private String driverBy;

    /** 派车时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "派车时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date dispatchDate;

    /** 返回时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "返回时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date backDate;

    /** 本次里程数 */
    @Excel(name = "本次里程数")
    private Integer travelMileage;

    /** 派时里程 */
    @Excel(name = "派时里程")
    private Integer startMileage;

    /** 还车里程 */
    @Excel(name = "还车里程")
    private Integer endMileage;

    /** 耗油量 */
    @Excel(name = "耗油量")
    private Integer oilConsumption;

    /** 派送单状态 */
    @Excel(name = "派送单状态")
    private Integer status;

    public void setDispatchId(Long dispatchId)
    {
        this.dispatchId = dispatchId;
    }

    public Long getDispatchId()
    {
        return dispatchId;
    }
    public void setDispatchCode(String dispatchCode)
    {
        this.dispatchCode = dispatchCode;
    }

    public String getDispatchCode()
    {
        return dispatchCode;
    }
    public void setDispatchTitle(String dispatchTitle)
    {
        this.dispatchTitle = dispatchTitle;
    }

    public String getDispatchTitle()
    {
        return dispatchTitle;
    }
    public void setVehicleId(Long vehicleId)
    {
        this.vehicleId = vehicleId;
    }

    public Long getVehicleId()
    {
        return vehicleId;
    }
    public void setDispatchBy(String dispatchBy)
    {
        this.dispatchBy = dispatchBy;
    }

    public String getDispatchBy()
    {
        return dispatchBy;
    }
    public void setDriverBy(String driverBy)
    {
        this.driverBy = driverBy;
    }

    public String getDriverBy()
    {
        return driverBy;
    }
    public void setDispatchDate(Date dispatchDate)
    {
        this.dispatchDate = dispatchDate;
    }

    public Date getDispatchDate()
    {
        return dispatchDate;
    }
    public void setBackDate(Date backDate)
    {
        this.backDate = backDate;
    }

    public Date getBackDate()
    {
        return backDate;
    }
    public void setTravelMileage(Integer travelMileage)
    {
        this.travelMileage = travelMileage;
    }

    public Integer getTravelMileage()
    {
        return travelMileage;
    }
    public void setStartMileage(Integer startMileage)
    {
        this.startMileage = startMileage;
    }

    public Integer getStartMileage()
    {
        return startMileage;
    }
    public void setEndMileage(Integer endMileage)
    {
        this.endMileage = endMileage;
    }

    public Integer getEndMileage()
    {
        return endMileage;
    }
    public void setOilConsumption(Integer oilConsumption)
    {
        this.oilConsumption = oilConsumption;
    }

    public Integer getOilConsumption()
    {
        return oilConsumption;
    }
    public void setStatus(Integer status)
    {
        this.status = status;
    }

    public Integer getStatus()
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("dispatchId", getDispatchId())
            .append("dispatchCode", getDispatchCode())
            .append("dispatchTitle", getDispatchTitle())
            .append("vehicleId", getVehicleId())
            .append("dispatchBy", getDispatchBy())
            .append("driverBy", getDriverBy())
            .append("dispatchDate", getDispatchDate())
            .append("backDate", getBackDate())
            .append("travelMileage", getTravelMileage())
            .append("startMileage", getStartMileage())
            .append("endMileage", getEndMileage())
            .append("oilConsumption", getOilConsumption())
            .append("remark", getRemark())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
