package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSaleOrderGroup;
import com.ximai.mes.md.service.IMdSaleOrderGroupService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 销售订单销售小组Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/md/ordergroup")
public class MdSaleOrderGroupController extends BaseController
{
    @Autowired
    private IMdSaleOrderGroupService mdSaleOrderGroupService;

    /**
     * 查询销售订单销售小组列表
     */
    @PreAuthorize("@ss.hasPermi('md:ordergroup:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSaleOrderGroup mdSaleOrderGroup)
    {
        startPage();
        List<MdSaleOrderGroup> list = mdSaleOrderGroupService.selectMdSaleOrderGroupList(mdSaleOrderGroup);
        return getDataTable(list);
    }

    /**
     * 获取销售订单销售小组详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:ordergroup:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(mdSaleOrderGroupService.selectMdSaleOrderGroupById(id));
    }

    /**
     * 新增销售订单销售小组
     */
    @PreAuthorize("@ss.hasPermi('md:ordergroup:add')")
    @Log(title = "销售订单销售小组", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSaleOrderGroup mdSaleOrderGroup)
    {
        return toAjax(mdSaleOrderGroupService.insertMdSaleOrderGroup(mdSaleOrderGroup));
    }

    /**
     * 修改销售订单销售小组
     */
    @PreAuthorize("@ss.hasPermi('md:ordergroup:edit')")
    @Log(title = "销售订单销售小组", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSaleOrderGroup mdSaleOrderGroup)
    {
        return toAjax(mdSaleOrderGroupService.updateMdSaleOrderGroup(mdSaleOrderGroup));
    }

    /**
     * 删除销售订单销售小组
     */
    @PreAuthorize("@ss.hasPermi('md:ordergroup:remove')")
    @Log(title = "销售订单销售小组", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(mdSaleOrderGroupService.deleteMdSaleOrderGroupByIds(ids));
    }
}
