package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdProductSpec;
import com.ximai.mes.md.service.IMdProductSpecService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 产品特性名称Controller
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@RestController
@RequestMapping("/md/spec")
public class MdProductSpecController extends BaseController
{
    @Autowired
    private IMdProductSpecService mdItemSpecService;

    /**
     * 查询产品特性名称列表
     */
    @PreAuthorize("@ss.hasPermi('md:spec:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdProductSpec mdProductSpec)
    {
        startPage();
        List<MdProductSpec> list = mdItemSpecService.selectMdItemSpecList(mdProductSpec);
        return getDataTable(list);
    }

    /**
     * 获取产品特性名称详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:spec:query')")
    @GetMapping(value = "/{itemSpecId}")
    public AjaxResult getInfo(@PathVariable("itemSpecId") Long itemSpecId)
    {
        return AjaxResult.success(mdItemSpecService.selectMdItemSpecByItemSpecId(itemSpecId));
    }

    /**
     * 新增产品特性名称
     */
    @PreAuthorize("@ss.hasPermi('md:spec:add')")
    @Log(title = "产品特性名称", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdProductSpec mdProductSpec)
    {
        return toAjax(mdItemSpecService.insertMdItemSpec(mdProductSpec));
    }

    /**
     * 修改产品特性名称
     */
    @PreAuthorize("@ss.hasPermi('md:spec:edit')")
    @Log(title = "产品特性名称", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdProductSpec mdProductSpec)
    {
        return toAjax(mdItemSpecService.updateMdItemSpec(mdProductSpec));
    }

    /**
     * 删除产品特性名称
     */
    @PreAuthorize("@ss.hasPermi('md:spec:remove')")
    @Log(title = "产品特性名称", businessType = BusinessType.DELETE)
	@DeleteMapping("/{itemSpecIds}")
    public AjaxResult remove(@PathVariable Long[] itemSpecIds)
    {
        return toAjax(mdItemSpecService.deleteMdItemSpecByItemSpecIds(itemSpecIds));
    }
}
