package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdProductLook;
import com.ximai.mes.md.service.IMdProductLookService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 产品外观Controller
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@RestController
@RequestMapping("/md/look")
public class MdProductLookController extends BaseController
{
    @Autowired
    private IMdProductLookService mdProductLookService;

    /**
     * 查询产品外观列表
     */
    @PreAuthorize("@ss.hasPermi('md:look:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdProductLook mdProductLook)
    {
        startPage();
        List<MdProductLook> list = mdProductLookService.selectMdProductLookList(mdProductLook);
        return getDataTable(list);
    }


    /**
     * 获取产品外观详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:look:query')")
    @GetMapping(value = "/{itemId}")
    public AjaxResult getInfo(@PathVariable("itemId") Long itemId)
    {
        return AjaxResult.success(mdProductLookService.selectMdProductLookByItemId(itemId));
    }

    /**
     * 新增产品外观
     */
    @PreAuthorize("@ss.hasPermi('md:look:add')")
    @Log(title = "产品外观", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdProductLook mdProductLook)
    {
        return toAjax(mdProductLookService.insertMdProductLook(mdProductLook));
    }

    /**
     * 修改产品外观
     */
    @PreAuthorize("@ss.hasPermi('md:look:edit')")
    @Log(title = "产品外观", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdProductLook mdProductLook)
    {
        return toAjax(mdProductLookService.updateMdProductLook(mdProductLook));
    }

    /**
     * 删除产品外观
     */
    @PreAuthorize("@ss.hasPermi('md:look:remove')")
    @Log(title = "产品外观", businessType = BusinessType.DELETE)
	@DeleteMapping("/{itemIds}")
    public AjaxResult remove(@PathVariable Long[] itemIds)
    {
        return toAjax(mdProductLookService.deleteMdProductLookByItemIds(itemIds));
    }
}
