package com.ximai.mes.kanban.controller;

import com.ximai.common.core.domain.AjaxResult;
import com.ximai.mes.kanban.dto.abnormal.AbnormalMonthStatDto;
import com.ximai.mes.kanban.dto.task.TaskStatDto;
import com.ximai.mes.kanban.service.KanbanTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Api("看板生产任务数据接口")
@RestController
@RequestMapping("/kanban/task")
public class KanbanTaskController {

    @Autowired
    private KanbanTaskService kanbanTaskService;

    @ApiOperation("工序当月统计")
    @PostMapping("/currentMonthStat")
    public AjaxResult<TaskStatDto> currentMonthStat() {
        TaskStatDto rst = kanbanTaskService.currentMonthStat();
        return AjaxResult.success(rst);
    }

}
