package com.ximai.mes.cal.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.cal.domain.CalShift;
import com.ximai.mes.cal.domain.vo.CalShiftVo;
import com.ximai.mes.cal.mapper.CalShiftMapper;
import com.ximai.mes.cal.service.ICalShiftService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 计划班次Service业务层处理
 *
 * @date 2022-06-06
 */
@Service
public class CalShiftServiceImpl implements ICalShiftService {
    @Autowired
    private CalShiftMapper calShiftMapper;

    /**
     * 查询计划班次
     *
     * @param shiftId 计划班次主键
     * @return 计划班次
     */
    @Override
    public CalShift selectCalShiftByShiftId(Long shiftId) {
        return calShiftMapper.selectCalShiftByShiftId(shiftId);
    }

    /**
     * 查询计划班次列表
     *
     * @param calShift 计划班次
     * @return 计划班次
     */
    @Override
    public List<CalShift> selectCalShiftList(CalShift calShift) {
        //        <if test="planId != null ">and plan_id = #{planId}</if>
        //            <if test="orderNum != null ">and order_num = #{orderNum}</if>
        //            <if test="shiftName != null  and shiftName != ''">and shift_name like concat('%', #{shiftName}, '%')</if>
        //            <if test="startTime != null ">and start_time = #{startTime}</if>
        //            <if test="endTime != null ">and end_time = #{endTime}</if>
        QueryWrapper<CalShift> calShiftVoQueryWrapper = new QueryWrapper<>();
        calShiftVoQueryWrapper.eq(StringUtils.isNotEmpty(calShift.getPlanId()), "plan_id", calShift.getPlanId());
        calShiftVoQueryWrapper.eq(StringUtils.isNotEmpty(calShift.getOrderNum()), "order_num", calShift.getOrderNum());
        calShiftVoQueryWrapper.like(StringUtils.isNotEmpty(calShift.getShiftName()), "shift_name", calShift.getShiftName());
        List<CalShift> calShifts = calShiftMapper.selectListByQw(calShiftVoQueryWrapper);


        Map<String, List<CalShift>> map = calShifts.stream().collect(Collectors.groupingBy(CalShift::getPlanCode));
        ArrayList<CalShift> objects = new ArrayList<>();
        for (Map.Entry<String, List<CalShift>> entry : map.entrySet()) {
            List<CalShift> value = entry.getValue();

            Map<String, List<CalShift>> listMap = value.stream().collect(Collectors.groupingBy(CalShift::getShiftName));

            if (CollectionUtil.isNotEmpty(listMap)) {
                for (Map.Entry<String, List<CalShift>> listEntry : listMap.entrySet()) {
                    List<CalShift> value1 = listEntry.getValue();
                    List<CalShift> collect2 = value1.stream().filter(x -> x.getOperType() == 0).collect(Collectors.toList());
                    List<CalShift> collect = value1.stream().filter(x -> x.getOperType() == 1).collect(Collectors.toList());
                    CalShift calShift1 = collect2.get(0);
                    calShift1.setBreakTimeList(collect);
                    objects.add(calShift1);
                }
            }
        }
        return objects;
    }

    @Override
    public int checkShiftCount(Long planId) {
        return calShiftMapper.checkShiftCount(planId);
    }

    /**
     * 新增计划班次
     *
     * @param calShift 计划班次
     * @return 结果
     */
    @Override
    public int insertCalShift(CalShift calShift) {
        calShift.createAction();
        return calShiftMapper.insertCalShift(calShift);
    }

    /**
     * 修改计划班次
     *
     * @param calShift 计划班次
     * @return 结果
     */
    @Override
    public int updateCalShift(CalShift calShift) {
        calShift.updateAction();
        return calShiftMapper.updateCalShift(calShift);
    }

    /**
     * 批量删除计划班次
     *
     * @param shiftIds 需要删除的计划班次主键
     * @return 结果
     */
    @Override
    public int deleteCalShiftByShiftIds(Long[] shiftIds) {
        return calShiftMapper.deleteCalShiftByShiftIds(shiftIds);
    }

    /**
     * 删除计划班次信息
     *
     * @param shiftId 计划班次主键
     * @return 结果
     */
    @Override
    public int deleteCalShiftByShiftId(Long shiftId) {
        return calShiftMapper.deleteCalShiftByShiftId(shiftId);
    }

    @Override
    public int deleteByPlanId(Long planId) {
        return calShiftMapper.deleteByPlanId(planId);
    }


    @Override
    public List<CalShiftVo> getDetailShift(String shiftType) {
        List<CalShiftVo> resultList = new ArrayList<>();
        if (UserConstants.CAL_SHIFT_TYPE_SINGLE.equals(shiftType)) {
            CalShiftVo shift = new CalShiftVo();
            shift.setShiftName(UserConstants.CAL_SHIFT_NAME_DAY);
            shift.setOrderNum(1);
            shift.setStartTime("8:00");
            shift.setEndTime("18:00");
            List<CalShiftVo> list = new ArrayList<>();
            CalShiftVo breakShift = new CalShiftVo();
            breakShift.setBreakStartTime("12:00");
            breakShift.setBreakEndTime("14:00");
            breakShift.setStartTime(null);
            breakShift.setEndTime(null);
            breakShift.setOrderNum(1);

            list.add(breakShift);
            shift.setBreakTimeList(list);

            resultList.add(shift);
        } else if (UserConstants.CAL_SHIFT_TYPE_TWO.equals(shiftType)) {
            CalShiftVo shiftDay = new CalShiftVo();
            shiftDay.setShiftName(UserConstants.CAL_SHIFT_NAME_DAY);
            shiftDay.setOrderNum(1);
            shiftDay.setStartTime("8:00");
            shiftDay.setEndTime("20:00");

            List<CalShiftVo> list = new ArrayList<>();
            CalShiftVo breakShift = new CalShiftVo();
            breakShift.setBreakStartTime("12:00");
            breakShift.setBreakEndTime("14:00");
            breakShift.setStartTime(null);
            breakShift.setEndTime(null);
            breakShift.setOrderNum(1);

            list.add(breakShift);
            shiftDay.setBreakTimeList(list);

            CalShiftVo shiftNight = new CalShiftVo();
            shiftNight.setShiftName(UserConstants.CAL_SHIFT_NAME_NIGHT);
            shiftNight.setOrderNum(2);
            shiftNight.setStartTime("20:00");
            shiftNight.setEndTime("8:00");

            List<CalShiftVo> list2 = new ArrayList<>();
            CalShiftVo breakShift2 = new CalShiftVo();
            breakShift2.setBreakStartTime("00:00");
            breakShift2.setBreakEndTime("1:00");
            breakShift2.setStartTime(null);
            breakShift2.setEndTime(null);
            breakShift2.setOrderNum(1);

            list2.add(breakShift2);
            shiftNight.setBreakTimeList(list2);

            resultList.add(shiftDay);
            resultList.add(shiftNight);

        } else {
            CalShiftVo shiftDay = new CalShiftVo();
            shiftDay.setShiftName(UserConstants.CAL_SHIFT_NAME_DAY);
            shiftDay.setOrderNum(1);
            shiftDay.setStartTime("8:00");
            shiftDay.setEndTime("16:00");


            List<CalShiftVo> list2 = new ArrayList<>();
            CalShiftVo breakShift2 = new CalShiftVo();
            breakShift2.setBreakStartTime("12:00");
            breakShift2.setBreakEndTime("14:00");
            breakShift2.setStartTime(null);
            breakShift2.setEndTime(null);
            breakShift2.setOrderNum(1);

            list2.add(breakShift2);
            shiftDay.setBreakTimeList(list2);

            CalShiftVo shiftMid = new CalShiftVo();
            shiftMid.setShiftName(UserConstants.CAL_SHIFT_NAME_MID);
            shiftMid.setOrderNum(2);
            shiftMid.setStartTime("16:00");
            shiftMid.setEndTime("00:00");

            CalShiftVo shiftNight = new CalShiftVo();
            shiftNight.setShiftName(UserConstants.CAL_SHIFT_NAME_NIGHT);
            shiftNight.setOrderNum(3);
            shiftNight.setStartTime("00:00");
            shiftNight.setEndTime("8:00");

            List<CalShiftVo> list3 = new ArrayList<>();
            CalShiftVo breakShift3 = new CalShiftVo();

            breakShift3.setBreakStartTime("00:00");
            breakShift3.setBreakEndTime("1:00");
            breakShift3.setStartTime(null);
            breakShift3.setEndTime(null);
            breakShift3.setOrderNum(1);
            list3.add(breakShift3);
            shiftNight.setBreakTimeList(list3);

            resultList.add(shiftNight);
            resultList.add(shiftDay);
            resultList.add(shiftMid);
        }

        Arrays.sort(resultList.toArray(new CalShiftVo[resultList.size()]));
        return resultList;
    }
}
