package com.ximai.framework.config;

import com.ximai.common.core.domain.model.LoginUser;
import com.ximai.common.utils.SecurityUtils;
import com.ximai.common.utils.data.StringUtils;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.support.RequestContextUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Locale;

public class XimaiLocaleResolver implements LocaleResolver {
    @Override
    public void setLocale(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) {
    }

    @Override
    public Locale resolveLocale(HttpServletRequest request) {
        if(!SecurityUtils.isLogin()){
            return Locale.getDefault();
        }else{
            String locale = SecurityUtils.getLoginUser().getUser().getLocale();
            if(StringUtils.isEmpty(locale)){
                return Locale.getDefault();
            }
            String[] localeArr = locale.split("-");
            if(localeArr.length==1){
                return new Locale(locale, "");
            }else{
                return new Locale(localeArr[0], localeArr[1]);
            }
        }
    }
}

