package com.ximai.common.config;

import com.alibaba.fastjson.JSONObject;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * 读取项目相关配置
 */
@Component
@ConfigurationProperties(prefix = "ximai-mes")
public class RuoYiConfig {

    public final static String OS_NAME = System.getProperty("os.name");
 
    /**
     * 项目名称
     */
    private String name;

    /**
     * 版本
     */
    private String version;

    /**
     * 版权年份
     */
    private String copyrightYear;


    /**
     * 实例演示开关
     */
    private boolean demoEnabled;

    private static String profile;

    /**
     * 获取地址开关
     */
    private boolean addressEnabled;

    /**
     * 验证码类型
     */
    private String captchaType;

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(final String version) {
        this.version = version;
    }

    public String getCopyrightYear() {
        return copyrightYear;
    }

    public void setCopyrightYear(final String copyrightYear) {
        this.copyrightYear = copyrightYear;
    }

    public boolean isDemoEnabled() {
        return demoEnabled;
    }

    public void setDemoEnabled(final boolean demoEnabled) {
        this.demoEnabled = demoEnabled;
    }

    public static String getProfile() {
        return profile;
    }

    public void setProfile(final String profile) {
        this.profile = profile;
    }

    public boolean isAddressEnabled() {
        return addressEnabled;
    }

    public void setAddressEnabled(final boolean addressEnabled) {
        this.addressEnabled = addressEnabled;
    }

    public String getCaptchaType() {
        return captchaType;
    }

    public void setCaptchaType(final String captchaType) {
        this.captchaType = captchaType;
    }

    private static RuoYiConfig config;

    @PostConstruct
    public void init() {
        config = this;
        System.out.println(JSONObject.toJSONString(this));
    }

    private static RuoYiConfig getConfig() {
        return config;
    }

    public static boolean getAddressEnabledStatic() {
        return getConfig().addressEnabled;
    }


    public static String getCaptchaTypeStatic() {
        return getConfig().captchaType;
    }

    /**
     * 获取导入上传路径
     */
    public static String getImportPath()
    {
        return getProfile() + "/import";
    }

    /**
     * 获取头像上传路径
     */
    public static String getAvatarPath()
    {
        return getProfile() + "/static/avatar";
    }

    /**
     * 获取下载路径
     */
    public static String getDownloadPath()
    {
        return getProfile() + "/download/";
    }

    /**
     * 获取上传路径
     */
    public static String getUploadPath()
    {
        return getProfile() + "/upload";
    }
}
