package com.ximai.system.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.system.domain.SysUserAssocintionPrint;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;


/**
 * 人员关联打印机表Mapper接口
 *
 * @author generator
 * @date 2024-03-16
 */
public interface SysUserAssocintionPrintMapper extends BaseMapper<SysUserAssocintionPrint>
{
    /**
     * 查询人员关联打印机表
     *
     * @param userPrintId 人员关联打印机表主键
     * @return 人员关联打印机表
     */
    public SysUserAssocintionPrint selectSysUserAssocintionPrintByUserPrintId(Long userPrintId);

    public SysUserAssocintionPrint selectSysUserAssocintionPrintByUserPrintIdUserId(Long userId);

    @Select("select *from sys_user_associntion_print where user_id=#{userId}")
    SysUserAssocintionPrint selectSysUserAssocintionPrintByUserPrintIdUserId2(@Param("userId") Long userId);

    /**
     * 查询人员关联打印机表列表
     *
     * @param sysUserAssocintionPrint 人员关联打印机表
     * @return 人员关联打印机表集合
     */
    public List<SysUserAssocintionPrint> selectSysUserAssocintionPrintList(SysUserAssocintionPrint sysUserAssocintionPrint);

    /**
     * 新增人员关联打印机表
     *
     * @param sysUserAssocintionPrint 人员关联打印机表
     * @return 结果
     */
    public int insertSysUserAssocintionPrint(SysUserAssocintionPrint sysUserAssocintionPrint);

    /**
     * 修改人员关联打印机表
     *
     * @param sysUserAssocintionPrint 人员关联打印机表
     * @return 结果
     */
    public int updateSysUserAssocintionPrint(SysUserAssocintionPrint sysUserAssocintionPrint);

    /**
     * 删除人员关联打印机表
     *
     * @param userPrintId 人员关联打印机表主键
     * @return 结果
     */
    public int deleteSysUserAssocintionPrintByUserPrintId(Long userPrintId);

    /**
     * 批量删除人员关联打印机表
     *
     * @param userPrintIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSysUserAssocintionPrintByUserPrintIds(Long[] userPrintIds);
}
