package com.ximai.mes.wm.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.wm.mapper.WmIssueRecordMapper;
import com.ximai.mes.wm.domain.WmIssueRecord;
import com.ximai.mes.wm.service.IWmIssueRecordService;

/**
 * pad传mes领料单记录标Service业务层处理
 *
 * @author generator
 * @date 2024-04-07
 */
@Service
public class WmIssueRecordServiceImpl implements IWmIssueRecordService
{
    @Autowired
    private WmIssueRecordMapper wmIssueRecordMapper;

    /**
     * 查询pad传mes领料单记录标
     *
     * @param issueRecordId pad传mes领料单记录标主键
     * @return pad传mes领料单记录标
     */
    @Override
    public WmIssueRecord selectWmIssueRecordByIssueRecordId(Long issueRecordId)
    {
        return wmIssueRecordMapper.selectWmIssueRecordByIssueRecordId(issueRecordId);
    }

    /**
     * 查询pad传mes领料单记录标列表
     *
     * @param wmIssueRecord pad传mes领料单记录标
     * @return pad传mes领料单记录标
     */
    @Override
    public List<WmIssueRecord> selectWmIssueRecordList(WmIssueRecord wmIssueRecord)
    {
        return wmIssueRecordMapper.selectWmIssueRecordList(wmIssueRecord);
    }

    /**
     * 新增pad传mes领料单记录标
     *
     * @param wmIssueRecord pad传mes领料单记录标
     * @return 结果
     */
    @Override
    public int insertWmIssueRecord(WmIssueRecord wmIssueRecord)
    {
        wmIssueRecord.setCreateBy(SecurityUtils.getUsername());
        wmIssueRecord.setCreateTime(DateUtils.getNowDate());
        return wmIssueRecordMapper.insertWmIssueRecord(wmIssueRecord);
    }

    /**
     * 修改pad传mes领料单记录标
     *
     * @param wmIssueRecord pad传mes领料单记录标
     * @return 结果
     */
    @Override
    public int updateWmIssueRecord(WmIssueRecord wmIssueRecord)
    {
        wmIssueRecord.setUpdateBy(SecurityUtils.getUsername());
        wmIssueRecord.setUpdateTime(DateUtils.getNowDate());
        return wmIssueRecordMapper.updateWmIssueRecord(wmIssueRecord);
    }

    /**
     * 批量删除pad传mes领料单记录标
     *
     * @param issueRecordIds 需要删除的pad传mes领料单记录标主键
     * @return 结果
     */
    @Override
    public int deleteWmIssueRecordByIssueRecordIds(Long[] issueRecordIds)
    {
        return wmIssueRecordMapper.deleteWmIssueRecordByIssueRecordIds(issueRecordIds);
    }

    /**
     * 删除pad传mes领料单记录标信息
     *
     * @param issueRecordId pad传mes领料单记录标主键
     * @return 结果
     */
    @Override
    public int deleteWmIssueRecordByIssueRecordId(Long issueRecordId)
    {
        return wmIssueRecordMapper.deleteWmIssueRecordByIssueRecordId(issueRecordId);
    }
}
