package com.ximai.mes.wm.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcess;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkOrderProcessItem;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.vo.ProTaskVo;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderProcessMapper;
import com.ximai.mes.pro.mapper.task.ProTaskMapper;
import com.ximai.mes.wm.domain.WmIssueLine;
import com.ximai.mes.wm.domain.tx.WmIssueLineJoinBean;
import com.ximai.mes.wm.mapper.WmIssueLineMapper;
import com.ximai.mes.wm.service.IWmIssueLineService;
import com.google.common.base.Joiner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 生产领料单行Service业务层处理
 *
 * @date 2022-07-14
 */
@Service
public class WmIssueLineServiceImpl implements IWmIssueLineService {
    @Autowired
    private WmIssueLineMapper wmIssueLineMapper;


    @Resource
    private ProTaskMapper proTaskMapper;


    @Autowired
    private ProWorkOrderProcessMapper proWorkOrderProcessMapper;

    /**
     * 查询生产领料单行
     *
     * @param lineId 生产领料单行主键
     * @return 生产领料单行
     */
    @Override
    public WmIssueLine selectWmIssueLineByLineId(Long lineId) {
        return wmIssueLineMapper.selectWmIssueLineByLineId(lineId);
    }

    /**
     * 查询生产领料单行列表
     *
     * @param wmIssueLine 生产领料单行
     * @return 生产领料单行
     */
    @Override
    public List<WmIssueLine> selectWmIssueLineList(WmIssueLine wmIssueLine) {
        return wmIssueLineMapper.selectWmIssueLineList(wmIssueLine);
    }

    @Override
    public List<WmIssueLineJoinBean> selectWmIssueLineBeanList(WmIssueLine wmIssueLine) {
        Long taskId = wmIssueLine.getTaskId();
        String workorderCode = wmIssueLine.getWorkorderCode();
        String plNum = wmIssueLine.getPlNum();

        Set<String> workorderCodeSet = proTaskMapper.selectProTaskJoinWorkorder(new QueryWrapper<ProTask>().eq("t1.task_id", taskId)).stream().map(ProTaskVo::getWorkorderCode).collect(Collectors.toSet());
        if (StringUtils.isNotEmpty(workorderCode)) {
            workorderCodeSet.add(workorderCode);
        }


        //根据工单查询领用明细
        QueryWrapper<WmIssueLineJoinBean> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isEmpty(workorderCode)) {
            queryWrapper.in("t2.workorder_code", workorderCodeSet);
        } else {
            queryWrapper.in("t2.workorder_code", workorderCode);
        }

        queryWrapper.in(StringUtils.isNotEmpty(plNum), "t2.pl_num", plNum);
        List<WmIssueLineJoinBean> wmIssueLineJoinBeans = wmIssueLineMapper.selectWmIssueLineJoinList(queryWrapper);
        for (WmIssueLineJoinBean wmIssueLineJoinBean : wmIssueLineJoinBeans) {
            wmIssueLineJoinBean.setTotalBackNum(wmIssueLineJoinBean.getTotalBackNum() == null ? BigDecimal.ZERO : wmIssueLineJoinBean.getTotalBackNum().setScale(3, RoundingMode.UP));
        }
        return wmIssueLineJoinBeans;
    }



    @Override
    public List<WmIssueLineJoinBean> selectWmIssueLineSelect(WmIssueLine wmIssueLine) {
        Long taskId = wmIssueLine.getTaskId();
        String workorderCode = wmIssueLine.getWorkorderCode();
        String plNum = wmIssueLine.getPlNum();
        Long processId = proTaskMapper.selectProTaskByTaskId(taskId).getProcessId();
        List<ProTaskVo> tempTaskVoList = proTaskMapper.selectProTaskJoinWorkorder(new QueryWrapper<ProTask>().eq("t1.task_id", taskId));
        Set<Long> workorderIdSet = tempTaskVoList.stream().map(ProTaskVo::getWorkorderId).collect(Collectors.toSet());
        Set<String> workorderCodeSet = tempTaskVoList.stream().map(ProTaskVo::getWorkorderCode).collect(Collectors.toSet());
        List<WmIssueLineJoinBean> wmIssueLineJoinBeans=null;
        //查看当前工序又没有物料
        QueryWrapper<ProWorkOrderProcess> itemQuery = new QueryWrapper<>();
        if(StringUtils.isEmpty(workorderCode)){
            itemQuery.in("t2.workorder_id",workorderIdSet);
        }else{
            itemQuery.eq("t2.workorder_code",workorderCode);
        }
        itemQuery.eq("t2.process_id",processId);
        List<ProWorkOrderProcessItem> processItems = proWorkOrderProcessMapper.selectProWorkOrderProcessItem(itemQuery);
        if(CollectionUtil.isNotEmpty(processItems)){
            Set<Long> collect = processItems.stream().map(ProWorkOrderProcessItem::getItemId).collect(Collectors.toSet());
            //根据工单查询领用明细
            QueryWrapper<WmIssueLineJoinBean> queryWrapper = new QueryWrapper<>();
            if (StringUtils.isEmpty(workorderCode)) {
                queryWrapper.in("t2.workorder_code", workorderCodeSet);
            } else {
                queryWrapper.in("t2.workorder_code", workorderCode);
            }
            queryWrapper.in("t3.item_id", collect);
            wmIssueLineJoinBeans = wmIssueLineMapper.selectWmIssueLineJoinList(queryWrapper);
            for (WmIssueLineJoinBean wmIssueLineJoinBean : wmIssueLineJoinBeans) {
                wmIssueLineJoinBean.setTotalBackNum(wmIssueLineJoinBean.getTotalBackNum() == null ? BigDecimal.ZERO : wmIssueLineJoinBean.getTotalBackNum().setScale(3, RoundingMode.UP));
            }
        }
        return wmIssueLineJoinBeans;

    }




    @Override
    public List<WmIssueLineJoinBean> listFeedingInspection(Long taskId) {
        QueryWrapper<ProTask> query = new QueryWrapper<>();
        query.eq("t1.task_id", taskId);
        List<ProTaskVo> taskOrderlist = proTaskMapper.selectProTaskJoinWorkorder(query);
        Set<String> workorderCodeSet = taskOrderlist.stream().map(ProTaskVo::getWorkorderCode).collect(Collectors.toSet());
        Set<Long> workorderIds = taskOrderlist.stream().map(ProTaskVo::getWorkorderId).collect(Collectors.toSet());
        QueryWrapper<WmIssueLineJoinBean> query2 = new QueryWrapper<>();
        query2.in("t2.workorder_code", workorderCodeSet);
        QueryWrapper<WmIssueLineJoinBean> innerQuery = new QueryWrapper<WmIssueLineJoinBean>();
        innerQuery.in("workorder_id", workorderIds);
        innerQuery.eq("process_id", taskOrderlist.get(0).getProcessId());
        String values = Joiner.on("','").join(workorderCodeSet);
        values = "'" + values + "'";
        return wmIssueLineMapper.selectFeedingInspection(values, innerQuery);
    }

    /**
     * 查询生产领料单行列表
     *
     * @param wmIssueLine 生产领料单行
     * @return 生产领料单行
     */
    @Override
    public List<WmIssueLine> selectWmIssueLineByIssueIdsList(WmIssueLine wmIssueLine) {
        return wmIssueLineMapper.selectWmIssueLineByIssueIdsList(wmIssueLine);
    }


    /**
     * 新增生产领料单行
     *
     * @param wmIssueLine 生产领料单行
     * @return 结果
     */
    @Override
    public int insertWmIssueLine(WmIssueLine wmIssueLine) {
        wmIssueLine.createAction();
        return wmIssueLineMapper.insertWmIssueLine(wmIssueLine);
    }

    /**
     * 修改生产领料单行
     *
     * @param wmIssueLine 生产领料单行
     * @return 结果
     */
    @Override
    public int updateWmIssueLine(WmIssueLine wmIssueLine) {
        wmIssueLine.updateAction();
        return wmIssueLineMapper.updateWmIssueLine(wmIssueLine);
    }

    /**
     * 批量删除生产领料单行
     *
     * @param lineIds 需要删除的生产领料单行主键
     * @return 结果
     */
    @Override
    public int deleteWmIssueLineByLineIds(Long[] lineIds) {
        return wmIssueLineMapper.deleteWmIssueLineByLineIds(lineIds);
    }

    /**
     * 删除生产领料单行信息
     *
     * @param lineId 生产领料单行主键
     * @return 结果
     */
    @Override
    public int deleteWmIssueLineByLineId(Long lineId) {
        return wmIssueLineMapper.deleteWmIssueLineByLineId(lineId);
    }

    @Override
    public int deleteByIssueHeaderId(Long issueId) {
        return wmIssueLineMapper.deleteByIssueHeaderId(issueId);
    }
}
