package com.ximai.mes.wm.service;

import com.ximai.mes.wm.domain.WmIssueLine;
import com.ximai.mes.wm.domain.tx.WmIssueLineJoinBean;

import java.util.List;

/**
 * 生产领料单行Service接口
 *
 * @date 2022-07-14
 */
public interface IWmIssueLineService {
    /**
     * 查询生产领料单行
     *
     * @param lineId 生产领料单行主键
     * @return 生产领料单行
     */
    WmIssueLine selectWmIssueLineByLineId(Long lineId);

    /**
     * 查询生产领料单行列表
     *
     * @param wmIssueLine 生产领料单行
     * @return 生产领料单行集合
     */
    List<WmIssueLine> selectWmIssueLineList(WmIssueLine wmIssueLine);

    List<WmIssueLineJoinBean> selectWmIssueLineBeanList(WmIssueLine wmIssueLine);

    /**
     * 派工投料校验列表
     * @param taskId 任务ID
     * @return
     */
    List<WmIssueLineJoinBean> listFeedingInspection(Long taskId);

    /**
     * 查询生产领料单行
     *
     * @param wmIssueLine 生产领料单行主键
     * @return 生产领料单行
     */
    List<WmIssueLine> selectWmIssueLineByIssueIdsList(WmIssueLine wmIssueLine);

    List<WmIssueLineJoinBean> selectWmIssueLineSelect(WmIssueLine wmIssueLine);


    /**
     * 新增生产领料单行
     *
     * @param wmIssueLine 生产领料单行
     * @return 结果
     */
    int insertWmIssueLine(WmIssueLine wmIssueLine);

    /**
     * 修改生产领料单行
     *
     * @param wmIssueLine 生产领料单行
     * @return 结果
     */
    int updateWmIssueLine(WmIssueLine wmIssueLine);

    /**
     * 批量删除生产领料单行
     *
     * @param lineIds 需要删除的生产领料单行主键集合
     * @return 结果
     */
    int deleteWmIssueLineByLineIds(Long[] lineIds);

    /**
     * 删除生产领料单行信息
     *
     * @param lineId 生产领料单行主键
     * @return 结果
     */
    int deleteWmIssueLineByLineId(Long lineId);

    int deleteByIssueHeaderId(Long issueId);

}
