package com.ximai.mes.tm.service;

import com.ximai.mes.tm.domain.TmToolMaintenance;

import java.util.List;


/**
 * 要维护刀模版Service接口
 *
 * @author generator
 * @date 2024-02-02
 */
public interface ITmToolMaintenanceService
{
    public static final String CODES = "MATERIAL_REQUEST_CODE";

    /**
     * 查询要维护刀模版
     *
     * @param toolMainId 要维护刀模版主键
     * @return 要维护刀模版
     */
    public TmToolMaintenance selectTmToolMaintenanceByToolMaintenanceId(Long toolMainId);

    /**
     * 查询要维护刀模版列表
     *
     * @param tmToolMaintenance 要维护刀模版
     * @return 要维护刀模版集合
     */
    public List<TmToolMaintenance> selectTmToolMaintenanceList(TmToolMaintenance tmToolMaintenance);

    /**
     * 新增要维护刀模版
     *
     * @param tmToolMaintenance 要维护刀模版
     * @return 结果
     */
    public int insertTmToolMaintenance(TmToolMaintenance tmToolMaintenance);

    /**
     * 修改要维护刀模版
     *
     * @param TmToolMaintenance 要维护刀模版
     * @return 结果
     */
    public int updateTmToolMaintenance(TmToolMaintenance TmToolMaintenance);

    /**
     * 批量删除要维护刀模版
     *
     * @param toolMaintenanceId 需要删除的要维护刀模版主键集合
     * @return 结果
     */
    public int deleteTmToolMaintenanceByToolMaintenanceIds(Long toolMaintenanceId);


    public int deleteTmToolMainToolMainIds(Long toolMaintenanceId);

    public void insertTmToolMaintenances(TmToolMaintenance tmToolMaintenance);


}
