package com.ximai.mes.tm.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.tm.domain.TmToolRequestItem;
import com.ximai.mes.tm.service.ITmToolRequestItemService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 刀模版物料申请单Controller
 *
 * @author generator
 * @date 2024-02-02
 */
@RestController
@RequestMapping("/tm/tmToolRequestItem")
public class TmToolRequestItemController extends BaseController
{
    @Autowired
    private ITmToolRequestItemService tmToolRequestItemService;

    /**
     * 查询刀模版物料申请单列表
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestItem:list')")
    @GetMapping("/list")
    public TableDataInfo list(TmToolRequestItem tmToolRequestItem)
    {
        startPage();
        List<TmToolRequestItem> list = tmToolRequestItemService.selectTmToolRequestItemList(tmToolRequestItem);
        return getDataTable(list);
    }

    /**
     * 获取刀模版物料申请单详细信息
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestItem:query')")
    @GetMapping(value = "/{toolRequestItemId}")
    public AjaxResult getInfo(@PathVariable("toolRequestItemId") Long toolRequestItemId)
    {
        return AjaxResult.success(tmToolRequestItemService.selectTmToolRequestItemByToolRequestItemId(toolRequestItemId));
    }

    /**
     * 新增刀模版物料申请单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestItem:add')")
    @Log(title = "刀模版物料申请单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TmToolRequestItem tmToolRequestItem)
    {
        return toAjax(tmToolRequestItemService.insertTmToolRequestItem(tmToolRequestItem));
    }

    /**
     * 修改刀模版物料申请单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestItem:edit')")
    @Log(title = "刀模版物料申请单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TmToolRequestItem tmToolRequestItem)
    {
        return toAjax(tmToolRequestItemService.updateTmToolRequestItem(tmToolRequestItem));
    }

    /**
     * 删除刀模版物料申请单
     */
    @PreAuthorize("@ss.hasPermi('tm:tmToolRequestItem:remove')")
    @Log(title = "刀模版物料申请单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{toolRequestItemIds}")
    public AjaxResult remove(@PathVariable Long[] toolRequestItemIds)
    {
        return toAjax(tmToolRequestItemService.deleteTmToolRequestItemByToolRequestItemIds(toolRequestItemIds));
    }
}
