package com.ximai.mes.restful;

import com.alibaba.fastjson.JSON;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.framework.security.BasicAuth;
import com.ximai.mes.md.service.IMdWorkshopService;
import com.ximai.mes.md.vo.MdWorkshopVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * title: 车间信息接口
 * author:ZHT
 * date:2024/3/18
 * description:
 */
@RestController
@RequestMapping(value = "/api/v1/workshop")
public class WorkshopRestController {
    @Autowired
    private IMdWorkshopService mdWorkshopService;

    @ApiOperation(value = "车间信息创建")
    @BasicAuth
    @RequestMapping(value = "/workshopCreate", method = RequestMethod.POST)
    public AjaxResult WorkshopCreate(@RequestBody String  mdWorkshopJson) {

        MdWorkshopVo mdWorkshopVo = JSON.parseObject(mdWorkshopJson).toJavaObject(MdWorkshopVo.class);

        int i = mdWorkshopService.workshopCreate(mdWorkshopVo);
        if(i == 2){
            return AjaxResult.success("修改成功");
        }
        if(i == 3){
            return AjaxResult.success("关闭成功");
        }

        return AjaxResult.success("新增成功");
    }
}
