package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.mes.config.TrimStringDeserializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 客户 MdClientErpDto
 *
 * @date 2024-10-18
 */
@Data
public class MdClientErpDto
{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("客户编号")
    @JsonProperty("ma001")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String clientCode;

    @ApiModelProperty("客户全称")
    @JsonProperty("ma003")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String clientName;

    @ApiModelProperty("客户简称")
    @JsonProperty("ma002")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String clientNick;

    /**
     * 1:已核准、2:尚待核准、3:不准交易
     */
    @ApiModelProperty("核准状态")
    @JsonProperty("ma097")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String verifyStatus;

    @ApiModelProperty("备注")
    @JsonProperty("ma049")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String remark;
}
