package com.ximai.mes.remote;

import com.ximai.common.annotation.ApiLog;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.enums.InOutType;
import com.ximai.mes.remote.dto.*;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

import java.util.List;

/**
 * erp远程调用接口
 */
@FeignClient(value = "erp-service", url = "${remote.erp.url}")
public interface ErpService {

    @ApiLog(businessType = BusinessType.QUERY, inOutType = InOutType.OUT)
    @ApiOperation(value = "查询ERP供应商")
    @PostMapping(value = "/purma/getPurmaList")
    ErpResponseResult<List<MdVendorErpDto>> getVendorList(MdVendorErpQuery vendorErpQuery);

    @ApiLog(businessType = BusinessType.QUERY, inOutType = InOutType.OUT)
    @ApiOperation(value = "查询ERP客户")
    @PostMapping(value = "/copma/getCopmaList")
    ErpResponseResult<List<MdClientErpDto>> getClientList(MdClientErpQuery clientErpQuery);

    @ApiLog(businessType = BusinessType.QUERY, inOutType = InOutType.OUT)
    @ApiOperation(value = "查询ERP仓库")
    @PostMapping(value = "/cmsmc/getCmsmcList")
    ErpResponseResult<List<WmWarehouseErpDto>> getWarehouseList(WmWarehouseErpQuery warehouseErpQuery);


    @ApiLog(businessType = BusinessType.QUERY, inOutType = InOutType.OUT)
    @ApiOperation(value = "查询ERP物料")
    @PostMapping(value = "/invmb/getInvmbList")
    ErpResponseResult<List<MdItemErpDto>> getItemList(MdItemErpQuery itemErpQuery);
    @ApiLog(businessType = BusinessType.QUERY, inOutType = InOutType.OUT)
    @ApiOperation(value = "查询ERP物料分类")
    @PostMapping(value = "/invma/getInvmaList")
    ErpResponseResult<List<MdItemTypeErpDto>> getInvmaList(MdItemTypeErpQuery itemTypeErpQuery);

    @ApiLog(businessType = BusinessType.QUERY, inOutType = InOutType.OUT)
    @ApiOperation(value = "查询ERP工单")
    @PostMapping(value = "/mocta/getMoctaList")
    ErpResponseResult<List<ProWorkorderErpDto>> getWorkorderList(ProWorkorderErpQuery workorderErpQuery);


    @ApiLog(businessType = BusinessType.UPDATE, inOutType = InOutType.OUT)
    @ApiOperation(value = "ERP工单同步标识")
    @PostMapping(value = "/mocta/syncMark")
    ErpResponseResult<Object> workorderSyncMark(ProWorkorderSyncMarkUpdate syncMarkUpdate);


    @ApiLog(businessType = BusinessType.UPDATE, inOutType = InOutType.OUT)
    @ApiOperation(value = "ERP物料同步标识")
    @PostMapping(value = "/invmb/syncMark")
    ErpResponseResult<Object> materialSyncMark(MdItemSyncMarkUpdate syncMarkUpdate);


    @ApiLog(businessType = BusinessType.UPDATE, inOutType = InOutType.OUT)
    @ApiOperation(value = "ERP工单状态更新")
    @PostMapping(value = "/mocta/updateState")
    ErpResponseResult<Object> updateWorkorderState(ProWorkorderStateUpdate stateUpdate);

    @ApiLog(businessType = BusinessType.UPDATE, inOutType = InOutType.OUT)
    @ApiOperation(value = "ERP请购单创建")
    @PostMapping(value = "/purta/create")
    ErpResponseResult<Object> purchasingRequisitionCreate(PurchasingRequisitionCreate create);

    @ApiLog(businessType = BusinessType.UPDATE, inOutType = InOutType.OUT)
    @ApiOperation(value = "ERP完工入库创建")
    @PostMapping(value = "/moctf/create")
    ErpResponseResult<Object> finishStockInCreate(FinishStockInCreate create);


}
