package com.ximai.mes.qt.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.qt.domain.QtFactoryQuote;
import com.ximai.mes.qt.mapper.QtFactoryQuoteMapper;
import com.ximai.mes.qt.service.IQtFactoryQuoteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 工厂报价Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-24
 */
@Service
public class QtFactoryQuoteServiceImpl implements IQtFactoryQuoteService {
    @Autowired
    private QtFactoryQuoteMapper qtFactoryQuoteMapper;

    /**
     * 查询工厂报价
     *
     * @param qtFactoryQuote
     * @return 工厂报价
     */
    @Override
    public QtFactoryQuote selectQtFactoryQuoteById(QtFactoryQuote qtFactoryQuote) {
        return qtFactoryQuoteMapper.selectOne(qtFactoryQuote);
    }

    /**
     * 查询工厂报价列表
     *
     * @param qtFactoryQuote 工厂报价
     * @return 工厂报价
     */
    @Override
    public List<QtFactoryQuote> selectQtFactoryQuoteList(QtFactoryQuote qtFactoryQuote) {
        return qtFactoryQuoteMapper.selectQtFactoryQuoteList(qtFactoryQuote);
    }

    /**
     * 新增工厂报价
     *
     * @param qtFactoryQuote 工厂报价
     * @return 结果
     */
    @Override
    public int insertQtFactoryQuote(QtFactoryQuote qtFactoryQuote) {
        qtFactoryQuote.setCreateTime(DateUtils.getNowDate());
        return qtFactoryQuoteMapper.insertQtFactoryQuote(qtFactoryQuote);
    }

    /**
     * 修改工厂报价
     *
     * @param qtFactoryQuote 工厂报价
     * @return 结果
     */
    @Override
    public int updateQtFactoryQuote(QtFactoryQuote qtFactoryQuote) {
        qtFactoryQuote.setUpdateTime(DateUtils.getNowDate());
        checkUpdate(qtFactoryQuote);
        return qtFactoryQuoteMapper.updateQtFactoryQuote(qtFactoryQuote);
    }

    /**
     * 检测是否有在有效期内报价, 有则设置有效期至当前有效期开始
     */
    public void checkUpdate(QtFactoryQuote qtFactoryQuote) {
        if (!"3".equals(qtFactoryQuote.getState())) return;
        final QtFactoryQuote query = new QtFactoryQuote();
        query.setClientId(qtFactoryQuote.getClientId());
        query.setItemId(qtFactoryQuote.getItemId());
        query.setValidFrom(qtFactoryQuote.getValidFrom());
        query.setValidTo(qtFactoryQuote.getValidTo());
        final List<QtFactoryQuote> qtFactoryQuotes = qtFactoryQuoteMapper.selectQtFactoryQuoteList(query);
        if (CollUtil.isNotEmpty(qtFactoryQuotes)) {
            for (QtFactoryQuote factoryQuote : qtFactoryQuotes) {
                factoryQuote.setValidTo(DateUtil.offsetDay(qtFactoryQuote.getValidFrom(), -1));
                qtFactoryQuoteMapper.updateQtFactoryQuote(factoryQuote);
            }
        }
    }

    /**
     * 批量删除工厂报价
     *
     * @param ids 需要删除的工厂报价主键
     * @return 结果
     */
    @Override
    public int deleteQtFactoryQuoteByIds(Long[] ids) {
        return qtFactoryQuoteMapper.deleteQtFactoryQuoteByIds(ids);
    }

    /**
     * 删除工厂报价信息
     *
     * @param id 工厂报价主键
     * @return 结果
     */
    @Override
    public int deleteQtFactoryQuoteById(Long id) {
        return qtFactoryQuoteMapper.deleteQtFactoryQuoteById(id);
    }
}
