package com.ximai.mes.pro.service.prototypeMake;

import java.util.List;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcess;
import com.ximai.mes.pro.domain.vo.ProPrototypeMakeProcessVo;

/**
 * 样品制作工序Service接口
 *
 * @author zht
 * @date 2024-01-20
 */
public interface IProPrototypeMakeProcessService
{
    /**
     * 查询样品制作工序
     *
     * @param prototypeMakeProcessId 样品制作工序主键
     * @return 样品制作工序
     */
    public ProPrototypeMakeProcess selectProPrototypeMakeProcessByPrototypeMakeProcessId(Long prototypeMakeProcessId);

    /**
     * 查询样品制作工序列表
     *
     * @param proPrototypeMakeProcess 样品制作工序
     * @return 样品制作工序集合
     */
    public List<ProPrototypeMakeProcessVo> selectProPrototypeMakeProcessList(ProPrototypeMakeProcess proPrototypeMakeProcess);

    /**
     * 新增样品制作工序
     *
     * @param proPrototypeMakeProcess 样品制作工序
     * @return 结果
     */
    public int insertProPrototypeMakeProcess(ProPrototypeMakeProcess proPrototypeMakeProcess);

    /**
     * 修改样品制作工序
     *
     * @param proPrototypeMakeProcess 样品制作工序
     * @return 结果
     */
    public int updateProPrototypeMakeProcess(ProPrototypeMakeProcess proPrototypeMakeProcess);

    /**
     * 批量删除样品制作工序
     *
     * @param prototypeMakeProcessIds 需要删除的样品制作工序主键集合
     * @return 结果
     */
    public int deleteProPrototypeMakeProcessByPrototypeMakeProcessIds(Long[] prototypeMakeProcessIds);

    /**
     * 删除样品制作工序信息
     *
     * @param prototypeMakeProcessId 样品制作工序主键
     * @return 结果
     */
    public int deleteProPrototypeMakeProcessByPrototypeMakeProcessId(Long prototypeMakeProcessId);
}
