package com.ximai.mes.pro.service.productionSolution;

import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionSpecificationSheet;

import java.util.List;

/**
 * 生产方案规格书Service接口
 *
 * @author zht
 * @date 2024-03-23
 */
public interface IProProductionSolutionSpecificationSheetService {
    /**
     * 查询生产方案规格书
     *
     * @param specificationSheetId 生产方案规格书主键
     * @return 生产方案规格书
     */
    ProProductionSolutionSpecificationSheet selectProProductionSolutionSpecificationSheetBySpecificationSheetId(Long specificationSheetId);

    /**
     * 查询生产方案规格书列表
     *
     * @param proProductionSolutionSpecificationSheet 生产方案规格书
     * @return 生产方案规格书集合
     */
    List<ProProductionSolutionSpecificationSheet> selectProProductionSolutionSpecificationSheetList(ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet);

    /**
     * 新增生产方案规格书
     *
     * @param proProductionSolutionSpecificationSheet 生产方案规格书
     * @return 结果
     */
    int insertProProductionSolutionSpecificationSheet(ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet);

    /**
     * 修改生产方案规格书
     *
     * @param proProductionSolutionSpecificationSheet 生产方案规格书
     * @return 结果
     */
    int updateProProductionSolutionSpecificationSheet(ProProductionSolutionSpecificationSheet proProductionSolutionSpecificationSheet);

    /**
     * 批量删除生产方案规格书
     *
     * @param specificationSheetIds 需要删除的生产方案规格书主键集合
     * @return 结果
     */
    int deleteProProductionSolutionSpecificationSheetBySpecificationSheetIds(Long[] specificationSheetIds);

    /**
     * 删除生产方案规格书信息
     *
     * @param specificationSheetId 生产方案规格书主键
     * @return 结果
     */
    int deleteProProductionSolutionSpecificationSheetBySpecificationSheetId(Long specificationSheetId);

    /**
     * 通过生产版本查找规格说明书
     *
     * @param productionSolutionId
     * @return
     */
    ProProductionSolutionSpecificationSheet selectSpecificationSheetByProductionSolutionId(Long productionSolutionId);


    ProProductionSolutionSpecificationSheet getInfoByWorkorderId(Long workorderId);
}
