package com.ximai.mes.pro.service.productionSolution;

import com.github.pagehelper.Page;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolution;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionVo;

import java.util.List;

/**
 * 生产版本Service接口
 *
 * @author zht
 * @date 2024-01-23
 */
public interface IProProductionSolutionService {
    /**
     * 查询生产版本
     *
     * @param productionSolutionId 生产版本主键
     * @return 生产版本
     */
    ProProductionSolutionVo selectProProductionSolutionByProductionSolutionId(Long productionSolutionId);

    /**
     * 查询生产版本列表
     *
     * @param proProductionSolution 生产版本
     * @return 生产版本集合
     */
    List<ProProductionSolution> selectProProductionSolutionList(ProProductionSolution proProductionSolution);

    /**
     * 新增生产版本
     *
     * @return 结果
     */
    int insertProProductionSolution(ProProductionSolutionVo proProductionSolutionVo);

    /**
     * 修改生产版本
     *
     * @param proProductionSolutionVo 生产版本
     * @return 结果
     */
    int updateProProductionSolution(ProProductionSolutionVo proProductionSolutionVo);

    /**
     * 批量删除生产版本
     *
     * @param productionSolutionIds 需要删除的生产版本主键集合
     * @return 结果
     */
    int deleteProProductionSolutionByProductionSolutionIds(Long[] productionSolutionIds);

    /**
     * 删除生产版本信息
     *
     * @param productionSolutionId 生产版本主键
     * @return 结果
     */
    int deleteProProductionSolutionByProductionSolutionId(Long productionSolutionId);

    int productionSolutionCreate(ProProductionSolutionVo productionSolutionVo);

    int submitProProductionSolution(ProProductionSolutionVo proProductionSolutionVo);

    /**
     * 通过版本号和产品查询生产方案
     *
     * @param groupKey
     * @param groupCounter
     * @return
     */
    ProProductionSolution selectByGroupKeyAndGroupCounterAndSapItemCode(String groupKey, String groupCounter, String sapItemCode);
}
