package com.ximai.mes.pro.service.impl.prototypeMake;

import java.util.List;

import com.ximai.mes.pro.domain.vo.ProPrototypeMakeProcessVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.prototypeMake.ProPrototypeMakeProcessMapper;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcess;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeProcessService;

/**
 * 样品制作工序Service业务层处理
 *
 * @author zht
 * @date 2024-01-20
 */
@Service
public class ProPrototypeMakeProcessServiceImpl implements IProPrototypeMakeProcessService
{
    @Autowired
    private ProPrototypeMakeProcessMapper proPrototypeMakeProcessMapper;

    /**
     * 查询样品制作工序
     *
     * @param prototypeMakeProcessId 样品制作工序主键
     * @return 样品制作工序
     */
    @Override
    public ProPrototypeMakeProcess selectProPrototypeMakeProcessByPrototypeMakeProcessId(Long prototypeMakeProcessId)
    {
        return proPrototypeMakeProcessMapper.selectProPrototypeMakeProcessByPrototypeMakeProcessId(prototypeMakeProcessId);
    }

    /**
     * 查询样品制作工序列表
     *
     * @param proPrototypeMakeProcess 样品制作工序
     * @return 样品制作工序
     */
    @Override
    public List<ProPrototypeMakeProcessVo> selectProPrototypeMakeProcessList(ProPrototypeMakeProcess proPrototypeMakeProcess)
    {
        return proPrototypeMakeProcessMapper.selectProPrototypeMakeProcessList(proPrototypeMakeProcess);
    }

    /**
     * 新增样品制作工序
     *
     * @param proPrototypeMakeProcess 样品制作工序
     * @return 结果
     */
    @Override
    public int insertProPrototypeMakeProcess(ProPrototypeMakeProcess proPrototypeMakeProcess)
    {
        return proPrototypeMakeProcessMapper.insertProPrototypeMakeProcess(proPrototypeMakeProcess);
    }

    /**
     * 修改样品制作工序
     *
     * @param proPrototypeMakeProcess 样品制作工序
     * @return 结果
     */
    @Override
    public int updateProPrototypeMakeProcess(ProPrototypeMakeProcess proPrototypeMakeProcess)
    {
        return proPrototypeMakeProcessMapper.updateProPrototypeMakeProcess(proPrototypeMakeProcess);
    }

    /**
     * 批量删除样品制作工序
     *
     * @param prototypeMakeProcessIds 需要删除的样品制作工序主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeProcessByPrototypeMakeProcessIds(Long[] prototypeMakeProcessIds)
    {
        return proPrototypeMakeProcessMapper.deleteProPrototypeMakeProcessByPrototypeMakeProcessIds(prototypeMakeProcessIds);
    }

    /**
     * 删除样品制作工序信息
     *
     * @param prototypeMakeProcessId 样品制作工序主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeProcessByPrototypeMakeProcessId(Long prototypeMakeProcessId)
    {
        return proPrototypeMakeProcessMapper.deleteProPrototypeMakeProcessByPrototypeMakeProcessId(prototypeMakeProcessId);
    }
}
