package com.ximai.mes.pro.service.impl.prototypeMake;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.prototypeMake.ProPrototypeMakeProcessItemMapper;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcessItem;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeProcessItemService;

/**
 * 样品制作工序物料Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-20
 */
@Service
public class ProPrototypeMakeProcessItemServiceImpl implements IProPrototypeMakeProcessItemService
{
    @Autowired
    private ProPrototypeMakeProcessItemMapper proPrototypeMakeProcessItemMapper;

    /**
     * 查询样品制作工序物料
     *
     * @param prototypeMakeProcessItemId 样品制作工序物料主键
     * @return 样品制作工序物料
     */
    @Override
    public ProPrototypeMakeProcessItem selectProPrototypeMakeProcessItemByPrototypeMakeProcessItemId(Long prototypeMakeProcessItemId)
    {
        return proPrototypeMakeProcessItemMapper.selectProPrototypeMakeProcessItemByPrototypeMakeProcessItemId(prototypeMakeProcessItemId);
    }

    /**
     * 查询样品制作工序物料列表
     *
     * @param proPrototypeMakeProcessItem 样品制作工序物料
     * @return 样品制作工序物料
     */
    @Override
    public List<ProPrototypeMakeProcessItem> selectProPrototypeMakeProcessItemList(ProPrototypeMakeProcessItem proPrototypeMakeProcessItem)
    {
        return proPrototypeMakeProcessItemMapper.selectProPrototypeMakeProcessItemList(proPrototypeMakeProcessItem);
    }

    /**
     * 新增样品制作工序物料
     *
     * @param proPrototypeMakeProcessItem 样品制作工序物料
     * @return 结果
     */
    @Override
    public int insertProPrototypeMakeProcessItem(ProPrototypeMakeProcessItem proPrototypeMakeProcessItem)
    {
        return proPrototypeMakeProcessItemMapper.insertProPrototypeMakeProcessItem(proPrototypeMakeProcessItem);
    }

    /**
     * 修改样品制作工序物料
     *
     * @param proPrototypeMakeProcessItem 样品制作工序物料
     * @return 结果
     */
    @Override
    public int updateProPrototypeMakeProcessItem(ProPrototypeMakeProcessItem proPrototypeMakeProcessItem)
    {
        return proPrototypeMakeProcessItemMapper.updateProPrototypeMakeProcessItem(proPrototypeMakeProcessItem);
    }

    /**
     * 批量删除样品制作工序物料
     *
     * @param prototypeMakeProcessItemIds 需要删除的样品制作工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeProcessItemByPrototypeMakeProcessItemIds(Long[] prototypeMakeProcessItemIds)
    {
        return proPrototypeMakeProcessItemMapper.deleteProPrototypeMakeProcessItemByPrototypeMakeProcessItemIds(prototypeMakeProcessItemIds);
    }

    /**
     * 删除样品制作工序物料信息
     *
     * @param prototypeMakeProcessItemId 样品制作工序物料主键
     * @return 结果
     */
    @Override
    public int deleteProPrototypeMakeProcessItemByPrototypeMakeProcessItemId(Long prototypeMakeProcessItemId)
    {
        return proPrototypeMakeProcessItemMapper.deleteProPrototypeMakeProcessItemByPrototypeMakeProcessItemId(prototypeMakeProcessItemId);
    }
}
