package com.ximai.mes.pro.service.impl.productionMake;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.mapper.MdItemMapper;
import com.ximai.mes.pro.domain.vo.ProProductionMakeProcessToolVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.productionMake.ProProductionMakeProcessToolMapper;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeProcessTool;
import com.ximai.mes.pro.service.productionMake.IProProductionMakeProcessToolService;

/**
 * 打样申请工序工装夹具Service业务层处理
 *
 * @author generator
 * @date 2024-01-27
 */
@Service
public class ProProductionMakeProcessToolServiceImpl implements IProProductionMakeProcessToolService
{
    @Autowired
    private ProProductionMakeProcessToolMapper proProductionMakeProcessToolMapper;
    @Autowired
    private MdItemMapper mdItemMapper;
    /**
     * 查询打样申请工序工装夹具
     *
     * @param productionMakeProcessToolId 打样申请工序工装夹具主键
     * @return 打样申请工序工装夹具
     */
    @Override
    public ProProductionMakeProcessTool selectProProductionMakeProcessToolByProductionMakeProcessToolId(Long productionMakeProcessToolId)
    {
        return proProductionMakeProcessToolMapper.selectProProductionMakeProcessToolByProductionMakeProcessToolId(productionMakeProcessToolId);
    }

    /**
     * 查询打样申请工序工装夹具列表
     *
     * @param proProductionMakeProcessTool 打样申请工序工装夹具
     * @return 打样申请工序工装夹具
     */
    @Override
    public List<ProProductionMakeProcessTool> selectProProductionMakeProcessToolList(ProProductionMakeProcessTool proProductionMakeProcessTool)
    {
        return proProductionMakeProcessToolMapper.selectProProductionMakeProcessToolList(proProductionMakeProcessTool);
    }

    @Override
    public List<ProProductionMakeProcessToolVo> selectProProductionMakeProcessToolVoList(ProProductionMakeProcessTool proProductionMakeProcessTool)
    {
        List<ProProductionMakeProcessToolVo> rst = new ArrayList<ProProductionMakeProcessToolVo>();
        ProProductionMakeProcessTool query = new ProProductionMakeProcessTool();
        query.setProductionMakeId(proProductionMakeProcessTool.getProductionMakeId());
        List<ProProductionMakeProcessTool> list = proProductionMakeProcessToolMapper.selectProProductionMakeProcessToolList(query);
        List<Long> ids = list.stream().map(s->s.getToolId()).collect(Collectors.toList());
        Map<Long, MdItem> toolMap = new HashMap<Long, MdItem>();
        if(ids.size()>0){
            toolMap.putAll(mdItemMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getItemId(), s->s)));
        }
        list.forEach(s->{
            ProProductionMakeProcessToolVo vo = new ProProductionMakeProcessToolVo();
            BeanUtil.copyProperties(s, vo);
            if(toolMap.containsKey(s.getToolId())){
                BeanUtil.copyProperties(toolMap.get(s.getToolId()), vo);
            }
            rst.add(vo);
        });
        return rst;
    }

    /**
     * 新增打样申请工序工装夹具
     *
     * @param proProductionMakeProcessTool 打样申请工序工装夹具
     * @return 结果
     */
    @Override
    public int insertProProductionMakeProcessTool(ProProductionMakeProcessTool proProductionMakeProcessTool)
    {
        return proProductionMakeProcessToolMapper.insertProProductionMakeProcessTool(proProductionMakeProcessTool);
    }

    /**
     * 修改打样申请工序工装夹具
     *
     * @param proProductionMakeProcessTool 打样申请工序工装夹具
     * @return 结果
     */
    @Override
    public int updateProProductionMakeProcessTool(ProProductionMakeProcessTool proProductionMakeProcessTool)
    {
        return proProductionMakeProcessToolMapper.updateProProductionMakeProcessTool(proProductionMakeProcessTool);
    }

    /**
     * 批量删除打样申请工序工装夹具
     *
     * @param productionMakeProcessToolIds 需要删除的打样申请工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeProcessToolByProductionMakeProcessToolIds(Long[] productionMakeProcessToolIds)
    {
        return proProductionMakeProcessToolMapper.deleteProProductionMakeProcessToolByProductionMakeProcessToolIds(productionMakeProcessToolIds);
    }

    /**
     * 删除打样申请工序工装夹具信息
     *
     * @param productionMakeProcessToolId 打样申请工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteProProductionMakeProcessToolByProductionMakeProcessToolId(Long productionMakeProcessToolId)
    {
        return proProductionMakeProcessToolMapper.deleteProProductionMakeProcessToolByProductionMakeProcessToolId(productionMakeProcessToolId);
    }
}
