package com.ximai.mes.pro.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.pro.domain.ProWorkOrderArrangeRule;
import com.ximai.mes.pro.domain.vo.proWorkOrder.ArrangeRuleDto;
import com.ximai.mes.pro.mapper.ProWorkOrderArrangeRuleMapper;
import com.ximai.mes.pro.service.IProWorkOrderArrangeRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ximai.common.utils.SecurityUtils.getUsername;

/**
 * 编排单对照表Service业务层处理
 *
 * @author generator
 * @date 2024-03-14
 */
@Service
public class ProWorkOrderArrangeRuleServiceImpl implements IProWorkOrderArrangeRuleService {
    @Autowired
    private ProWorkOrderArrangeRuleMapper proWorkOrderArrangeRuleMapper;

    /**
     * 查询编排单对照表
     *
     * @param arrangeRuleId 编排单对照表主键
     * @return 编排单对照表
     */
    @Override
    public ProWorkOrderArrangeRule selectProWorkOrderArrangeRuleByArrangeRuleId(Long arrangeRuleId) {
        return proWorkOrderArrangeRuleMapper.selectProWorkOrderArrangeRuleByArrangeRuleId(arrangeRuleId);
    }

    /**
     * 查询编排单对照表列表
     *
     * @param proWorkOrderArrangeRule 编排单对照表
     * @return 编排单对照表
     */
    @Override
    public List<ProWorkOrderArrangeRule> selectProWorkOrderArrangeRuleList(ProWorkOrderArrangeRule proWorkOrderArrangeRule) {
        return proWorkOrderArrangeRuleMapper.selectProWorkOrderArrangeRuleList(proWorkOrderArrangeRule);
    }

    @Override
    public Map<String, ArrangeRuleDto> selectProWorkOrderArrangeRule(QueryWrapper<ProWorkOrderArrangeRule> query) {
        Map<String, ArrangeRuleDto> rst = new HashMap<String, ArrangeRuleDto>();
        List<Map<String, Object>> listMap = proWorkOrderArrangeRuleMapper.selectProWorkOrderArrangeRuleMap(query);
        List<ProWorkOrderArrangeRule> list = proWorkOrderArrangeRuleMapper.selectList(query);
        Map<Long,ProWorkOrderArrangeRule> ruleMap = list.stream().collect(Collectors.toMap(s->s.getArrangeRuleId(), s->s));
        listMap.forEach(s -> {
            ArrangeRuleDto dto = new ArrangeRuleDto();
            List<String> columnRule = new ArrayList<String>();
            s.keySet().forEach(key -> {
                Object v = s.get(key);
                if (v instanceof String && v != null) {
                    if ("Y".equals(v)) {
                        columnRule.add(key);
                    }
                }
            });
            List<String> newColumnRule = columnRule.stream().sorted().collect(Collectors.toList());
            dto.setRuleMap(newColumnRule);
            dto.setWorkOrderArrangeRule(ruleMap.get(s.get("arrange_rule_id")));

            rst.put((String) s.get("item_type_name") + (String) s.get("process_name"), dto);
        });
        return rst;
    }

    /**
     * 新增编排单对照表
     *
     * @param proWorkOrderArrangeRule 编排单对照表
     * @return 结果
     */
    @Override
    public int insertProWorkOrderArrangeRule(ProWorkOrderArrangeRule proWorkOrderArrangeRule) {
 

        proWorkOrderArrangeRule.setCreateBy(getUsername());
        proWorkOrderArrangeRule.setCreateTime(DateUtils.getNowDate());
        return proWorkOrderArrangeRuleMapper.insertProWorkOrderArrangeRule(proWorkOrderArrangeRule);
    }

    /**
     * 修改编排单对照表
     *
     * @param proWorkOrderArrangeRule 编排单对照表
     * @return 结果
     */
    @Override
    public int updateProWorkOrderArrangeRule(ProWorkOrderArrangeRule proWorkOrderArrangeRule) {

        proWorkOrderArrangeRule.setUpdateBy(getUsername());
        proWorkOrderArrangeRule.setUpdateTime(DateUtils.getNowDate());
        return proWorkOrderArrangeRuleMapper.updateProWorkOrderArrangeRule(proWorkOrderArrangeRule);
    }

    /**
     * 批量删除编排单对照表
     *
     * @param arrangeRuleIds 需要删除的编排单对照表主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderArrangeRuleByArrangeRuleIds(Long[] arrangeRuleIds) {
        return proWorkOrderArrangeRuleMapper.deleteProWorkOrderArrangeRuleByArrangeRuleIds(arrangeRuleIds);
    }

    /**
     * 删除编排单对照表信息
     *
     * @param arrangeRuleId 编排单对照表主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderArrangeRuleByArrangeRuleId(Long arrangeRuleId) {
        return proWorkOrderArrangeRuleMapper.deleteProWorkOrderArrangeRuleByArrangeRuleId(arrangeRuleId);
    }
}
