package com.ximai.mes.pro.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.ProScheduleSetupRuleMapper;
import com.ximai.mes.pro.domain.ProScheduleSetupRule;
import com.ximai.mes.pro.service.IProScheduleSetupRuleService;

/**
 * 排产换型对照信息Service业务层处理
 *
 * @author generator
 * @date 2024-04-01
 */
@Service
public class ProScheduleSetupRuleServiceImpl implements IProScheduleSetupRuleService
{
    @Autowired
    private ProScheduleSetupRuleMapper proScheduleSetupRuleMapper;

    /**
     * 查询排产换型对照信息
     *
     * @param ruleId 排产换型对照信息主键
     * @return 排产换型对照信息
     */
    @Override
    public ProScheduleSetupRule selectProScheduleSetupRuleByRuleId(Long ruleId)
    {
        return proScheduleSetupRuleMapper.selectProScheduleSetupRuleByRuleId(ruleId);
    }

    /**
     * 查询排产换型对照信息列表
     *
     * @param proScheduleSetupRule 排产换型对照信息
     * @return 排产换型对照信息
     */
    @Override
    public List<ProScheduleSetupRule> selectProScheduleSetupRuleList(ProScheduleSetupRule proScheduleSetupRule)
    {
        return proScheduleSetupRuleMapper.selectProScheduleSetupRuleList(proScheduleSetupRule);
    }

    /**
     * 新增排产换型对照信息
     *
     * @param proScheduleSetupRule 排产换型对照信息
     * @return 结果
     */
    @Override
    public int insertProScheduleSetupRule(ProScheduleSetupRule proScheduleSetupRule)
    {
        proScheduleSetupRule.setCreateBy(SecurityUtils.getUsername());
        proScheduleSetupRule.setCreateTime(DateUtils.getNowDate());
        return proScheduleSetupRuleMapper.insertProScheduleSetupRule(proScheduleSetupRule);
    }

    /**
     * 修改排产换型对照信息
     *
     * @param proScheduleSetupRule 排产换型对照信息
     * @return 结果
     */
    @Override
    public int updateProScheduleSetupRule(ProScheduleSetupRule proScheduleSetupRule)
    {
        return proScheduleSetupRuleMapper.updateProScheduleSetupRule(proScheduleSetupRule);
    }

    /**
     * 批量删除排产换型对照信息
     *
     * @param ruleIds 需要删除的排产换型对照信息主键
     * @return 结果
     */
    @Override
    public int deleteProScheduleSetupRuleByRuleIds(Long[] ruleIds)
    {
        return proScheduleSetupRuleMapper.deleteProScheduleSetupRuleByRuleIds(ruleIds);
    }

    /**
     * 删除排产换型对照信息信息
     *
     * @param ruleId 排产换型对照信息主键
     * @return 结果
     */
    @Override
    public int deleteProScheduleSetupRuleByRuleId(Long ruleId)
    {
        return proScheduleSetupRuleMapper.deleteProScheduleSetupRuleByRuleId(ruleId);
    }

    @Override
    public Map<String, Map<String, Integer>> selectProScheduleSetupRuleWithMap(QueryWrapper<ProScheduleSetupRule> query) {
        Map<String, Map<String, Integer>> rst = new HashMap<String, Map<String, Integer>>();
        List<Map<String, Object>> list = proScheduleSetupRuleMapper.selectProScheduleSetupRuleWithMap(query);
        list.forEach(s->{
            String key = (String)s.remove("item_type_name") + (String)s.remove("process_name");
            Map<String,Integer> convertMap = new HashMap<String,Integer>();
            s.forEach((k,v)->{
                convertMap.put(k, (Integer)v);
            });
            rst.put(key, convertMap);
        });
        return rst;
    }
}
