package com.ximai.mes.pro.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.pro.mapper.ProMaterialUsageRecordMapper;
import com.ximai.mes.pro.domain.ProMaterialUsageRecord;
import com.ximai.mes.pro.service.IProMaterialUsageRecordService;

/**
 * 生产物料扣减Service业务层处理
 *
 * @author mengcheng
 * @date 2024-01-20
 */
@Service
public class ProMaterialUsageRecordServiceImpl implements IProMaterialUsageRecordService
{
    @Autowired
    private ProMaterialUsageRecordMapper proMaterialUsageRecordMapper;

    /**
     * 查询生产物料扣减
     *
     * @param recordId 生产物料扣减主键
     * @return 生产物料扣减
     */
    @Override
    public ProMaterialUsageRecord selectProMaterialUsageRecordByRecordId(Long recordId)
    {
        return proMaterialUsageRecordMapper.selectProMaterialUsageRecordByRecordId(recordId);
    }

    /**
     * 查询生产物料扣减列表
     *
     * @param proMaterialUsageRecord 生产物料扣减
     * @return 生产物料扣减
     */
    @Override
    public List<ProMaterialUsageRecord> selectProMaterialUsageRecordList(ProMaterialUsageRecord proMaterialUsageRecord)
    {
        return proMaterialUsageRecordMapper.selectProMaterialUsageRecordList(proMaterialUsageRecord);
    }

    /**
     * 新增生产物料扣减
     *
     * @param proMaterialUsageRecord 生产物料扣减
     * @return 结果
     */
    @Override
    public int insertProMaterialUsageRecord(ProMaterialUsageRecord proMaterialUsageRecord)
    {
        return proMaterialUsageRecordMapper.insertProMaterialUsageRecord(proMaterialUsageRecord);
    }

    /**
     * 修改生产物料扣减
     *
     * @param proMaterialUsageRecord 生产物料扣减
     * @return 结果
     */
    @Override
    public int updateProMaterialUsageRecord(ProMaterialUsageRecord proMaterialUsageRecord)
    {
        return proMaterialUsageRecordMapper.updateProMaterialUsageRecord(proMaterialUsageRecord);
    }

    /**
     * 批量删除生产物料扣减
     *
     * @param recordIds 需要删除的生产物料扣减主键
     * @return 结果
     */
    @Override
    public int deleteProMaterialUsageRecordByRecordIds(Long[] recordIds)
    {
        return proMaterialUsageRecordMapper.deleteProMaterialUsageRecordByRecordIds(recordIds);
    }

    /**
     * 删除生产物料扣减信息
     *
     * @param recordId 生产物料扣减主键
     * @return 结果
     */
    @Override
    public int deleteProMaterialUsageRecordByRecordId(Long recordId)
    {
        return proMaterialUsageRecordMapper.deleteProMaterialUsageRecordByRecordId(recordId);
    }
}
