package com.ximai.mes.pro.schedule.impl.busi;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.pro.domain.ProProductQrcodeRule;
import com.ximai.mes.pro.dto.ProProductQrcodeRecordCreate;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleDto;
import com.ximai.mes.pro.schedule.impl.AlgorithmResultProcessImpl;
import com.ximai.mes.pro.service.IProMaterialRequestService;
import com.ximai.mes.pro.service.IProProductQrcodeRecordService;
import com.ximai.mes.pro.service.IProProductQrcodeRuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 产品序列号生成
 */
@Component
public class ProductQrcodeBuild implements ScheduleBusiProcess{

    @Autowired
    private IProProductQrcodeRecordService productQrcodeRecordService;
    @Autowired
    private IProProductQrcodeRuleService productQrcodeRuleService;
    @Autowired
    private IProProductQrcodeRuleService proProductQrcodeRuleService;
    @Override
    public void execute(List<JobResult> jobResults) {

        jobResults.forEach(job->{
            String taskBatch =  job.taskResultList != null && job.taskResultList.size() > 0 ? job.taskResultList.get(0).getProTask().getTaskBatch() : null;
            job.getWorkorderList().forEach(workorder->{
                ProProductQrcodeRule rule = productQrcodeRuleService.selectProProductQrcodeRuleNewest(workorder.getProductId(), workorder.getClientCode());
                if(rule ==null){
                    return;
                }
                List<String> qrcodes = productQrcodeRuleService.buildQrcode(rule, job.getQuantity().intValue());
                for(String qrcode : qrcodes){
                    ProProductQrcodeRecordCreate create = new ProProductQrcodeRecordCreate();
                    create.setQrcode(qrcode);
                    create.initByWorkorder(workorder);
                    create.setItemDesc(rule.getItemDesc());
                    //产品序列打印记录增加模板相关内容
                    create.setTemplateId(rule != null ? rule.getTemplateId() : null);
                    create.setTemplateCode(rule != null ? rule.getTemplateCode() : null);
                    create.setTemplateName(rule != null ? rule.getTemplateName() : null);
                    create.setTemplateType(rule != null ? rule.getTemplateType() : null);
                    create.setTaskBatch(taskBatch);
                    productQrcodeRecordService.insertProProductQrcodeRecord(create);
                }
            });
        });
    }

}
