package com.ximai.mes.pro.schedule.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.schedule.*;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkorderService;
import com.ximai.mes.pro.service.task.IProTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 1.
 * 加载设备挂载已排最新任务
 * 查询所有设备已排最新任务
 * 查询任务关联工单
 */
@Component
public class EquipmentNewestTaskAlgorithmData implements AlgorithmExtendDataSource {

    @Autowired
    IProTaskService taskService;
    @Autowired
    IProWorkorderService workorderService;

    @Override
    public void extendData(AlgorithmDataContext algorithmDataContext) {
        Map<Long,Equipment> equipmentMap = algorithmDataContext.getResources().stream().filter(s->{
            return s instanceof Equipment;
        }).map(s->(Equipment)s).collect(Collectors.toMap(s->s.getId(),s2->s2));
        QueryWrapper<ProTask> taskQuery = new QueryWrapper<ProTask>();
        List<ProTask> taskList = taskService.selectEquipmentNewestTask(taskQuery);
        if(taskList.isEmpty()){
            return;
        }
        List<String> arrangeCodes = new ArrayList<String>();
        taskList.forEach(s->{
            arrangeCodes.add(s.getArrangeCode());
        });
        //查询已排任务关联工单
        QueryWrapper<ProWorkorder> workorderQuery = new QueryWrapper<ProWorkorder>();
        workorderQuery.in("t1.arrange_code", arrangeCodes);
        List<ProWorkorder> workorderList = workorderService.selectListByQw(workorderQuery);
        Map<String,List<ProWorkorder>> workorderMap = workorderList.stream().collect(Collectors.groupingBy(s->s.getArrangeCode()));
        Map<String, Job> jobMap=new HashMap<String, Job>();
        //创建已排产JOB
        taskList.forEach(s->{
            if(!jobMap.containsKey(s.getArrangeCode())){
                Job job = new Job(s.getArrangeCode(), null);
                job.getJobExtend().setWorkorderList(workorderMap.getOrDefault(s.getArrangeCode(), new ArrayList<ProWorkorder>()));
                jobMap.put(s.getArrangeCode(), job);
            }
        });

        taskList.forEach(s->{
            Equipment equipment = equipmentMap.get(s.getWorkunitId());
            if(equipment!=null){
                Task scheduleTask = new Task(s.getTaskId(), jobMap.get(s.getArrangeCode()));
                scheduleTask.setProcessName(s.getProcessName());
                scheduleTask.setProcessId(s.getProcessId());
                scheduleTask.setScheduledEndedTime(Duration.between(LocalDateTime.now(),
                        DateUtil.toLocalDateTime(s.getScheduleEndDate())));
                equipment.getScheduleTask().add(scheduleTask);
            }
        });
    }

}
