package com.ximai.mes.pro.schedule;

import lombok.Data;

import java.util.List;
import java.util.Map;
import java.util.Objects;

@Data
public abstract class Resource {

    private Long id;

    /**
     * 可以并行开始无限个作业。
     */
    private Boolean isParallel;

    /**
     * ResourceData
     */
    private Map<String, Object> resourceData;

    /**
     * 资源日历
     */
    private List<Calendar> calendar;

    private CalendarManager calendarManager;

    public List<Calendar> getCalendar() {
        return calendarManager.getCalendar(this);
    }

    public List<Calendar.OccupiedCalendar> getOccupiedCalendar() {
        return calendarManager.getOccupiedCalendar(this);
    }

    public List<Calendar.LeisureCalendar> getLeisureCalendar() {
        return calendarManager.getLeisureCalendar(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Resource resource = (Resource) o;
        return Objects.equals(id, resource.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
