package com.ximai.mes.pro.mapper.productionMake;

import java.util.List;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeBom;

/**
 * 量产制作BOMMapper接口
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
public interface ProProductionMakeBomMapper
{
    /**
     * 查询量产制作BOM
     *
     * @param bomItemId 量产制作BOM主键
     * @return 量产制作BOM
     */
    public ProProductionMakeBom selectProProductionMakeBomByBomItemId(Long bomItemId);

    /**
     * 查询量产制作BOM列表
     *
     * @param proProductionMakeBom 量产制作BOM
     * @return 量产制作BOM集合
     */
    public List<ProProductionMakeBom> selectProProductionMakeBomList(ProProductionMakeBom proProductionMakeBom);

    /**
     * 新增量产制作BOM
     *
     * @param proProductionMakeBom 量产制作BOM
     * @return 结果
     */
    public int insertProProductionMakeBom(ProProductionMakeBom proProductionMakeBom);

    /**
     * 修改量产制作BOM
     *
     * @param proProductionMakeBom 量产制作BOM
     * @return 结果
     */
    public int updateProProductionMakeBom(ProProductionMakeBom proProductionMakeBom);

    /**
     * 删除量产制作BOM
     *
     * @param bomItemId 量产制作BOM主键
     * @return 结果
     */
    public int deleteProProductionMakeBomByBomItemId(Long bomItemId);

    /**
     * 批量删除量产制作BOM
     *
     * @param bomItemIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProProductionMakeBomByBomItemIds(Long[] bomItemIds);

    /**
     * 批量BOM
     *
     * @param productionMakeId 量产制作主键
     * @return 结果
     */
    public int deleteProProductionMakeBomByProductionMakeId(Long productionMakeId);
}
