package com.ximai.mes.pro.mapper;

import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProWorkstationMaterial;
import com.ximai.mes.pro.domain.vo.ProWorkstationMaterialVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

/**
 * 工作中心发料申请Mapper接口
 *
 * @author generator
 * @date 2024-07-26
 */
public interface ProWorkstationMaterialMapper extends BaseMapper<ProWorkstationMaterial>
{
    /**
     * 查询工作中心发料申请
     *
     * @param workstationMaterialId 工作中心发料申请主键
     * @return 工作中心发料申请
     */
    public ProWorkstationMaterialVo selectProWorkstationMaterialByWorkstationMaterialId(Long workstationMaterialId);

    /**
     * 查询工作中心发料申请列表
     *
     * @param proWorkstationMaterial 工作中心发料申请
     * @return 工作中心发料申请集合
     */
    public List<ProWorkstationMaterialVo> selectProWorkstationMaterialList(ProWorkstationMaterialVo proWorkstationMaterial);




    /**
     * 新增工作中心发料申请
     *
     * @param proWorkstationMaterial 工作中心发料申请
     * @return 结果
     */
    public int insertProWorkstationMaterial(ProWorkstationMaterial proWorkstationMaterial);

    /**
     * 修改工作中心发料申请
     *
     * @param proWorkstationMaterial 工作中心发料申请
     * @return 结果
     */
    public int updateProWorkstationMaterial(ProWorkstationMaterial proWorkstationMaterial);

    /**
     * 删除工作中心发料申请
     *
     * @param workstationMaterialId 工作中心发料申请主键
     * @return 结果
     */
    public int deleteProWorkstationMaterialByWorkstationMaterialId(Long workstationMaterialId);

    /**
     * 批量删除工作中心发料申请
     *
     * @param workstationMaterialIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProWorkstationMaterialByWorkstationMaterialIds(Long[] workstationMaterialIds);


    @Select("   select\n" +
            "            p.workstation_material_id,\n" +
            "            p.grant_num,\n" +
            "            p.wind_case,\n" +
            "            p.workstation_id,\n" +
            "            p.workstation_code,\n" +
            "            p.workstation_name,\n" +
            "            p.apply_no,\n" +
            "            p.item_id,\n" +
            "            p.material_type,\n" +
            "            p.task_id,\n" +
            "            p.apply_num,\n" +
            "            p.remak,\n" +
            "            p.attr1,\n" +
            "            p.attr2,\n" +
            "            p.attr3,\n" +
            "            p.attr4,\n" +
            "            p.create_by,\n" +
            "            p.create_time,\n" +
            "            p.update_by,\n" +
            "            p.update_time,\n" +
            "            p.start_time,\n" +
            "            p.end_time,\n" +
            "            p.workunit_name,\n" +
            "            p.workunit_code,\n" +
            "            p.apply_type,\n" +
            "            m.item_code,\n" +
            "            m.sap_item_code,\n" +
            "            m.item_name,\n" +
            "            pr.arrange_code ,\n" +
            "            pr.task_code,\n" +
            "            w.workshop_code,\n" +
            "            w.workshop_name\n" +
            "        from pro_workstation_material p\n" +
            "                 left join md_item m on p.item_id=m.item_id\n" +
            "                 left join pro_task pr on p.task_id=pr.task_id" +
            "                 left join md_workstation w on w.workstation_id=p.workstation_id" +
            "         ${ew.customSqlSegment} order by  p.grant_num IS NULL desc, p.create_time desc  ")
    List<ProWorkstationMaterialVo> selectProWorkstationMaterialLists(@Param("ew") QueryWrapper<ProWorkstationMaterial> query);

    @Select("select *from pro_workstation_material where apply_no=#{applyNo} and item_id=#{itemId}")
    ProWorkstationMaterial selectProWorkstationMaterialItemApplyNo(@Param("itemId") Long itemId,@Param("applyNo") String applyNo);
}
