package com.ximai.mes.pro.mapper;

import com.ximai.mes.pro.domain.ProRouteProcess;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 工艺组成Mapper接口
 *
 * @date 2022-05-13
 */
public interface ProRouteProcessMapper {
    /**
     * 查询工艺组成
     *
     * @param recordId 工艺组成主键
     * @return 工艺组成
     */
    public ProRouteProcess selectProRouteProcessByRecordId(Long recordId);

    /**
     * 查询工艺组成列表
     *
     * @param proRouteProcess 工艺组成
     * @return 工艺组成集合
     */
    public List<ProRouteProcess> selectProRouteProcessList(ProRouteProcess proRouteProcess);

    public ProRouteProcess checkOrderNumExists(ProRouteProcess proRouteProcess);

    public ProRouteProcess checkProcessExists(ProRouteProcess proRouteProcess);

    public ProRouteProcess checkUpdateFlagUnique(ProRouteProcess proRouteProcess);

    public ProRouteProcess findPreProcess(ProRouteProcess proRouteProcess);

    public ProRouteProcess findNextProcess(ProRouteProcess proRouteProcess);

    /**
     * 新增工艺组成
     *
     * @param proRouteProcess 工艺组成
     * @return 结果
     */
    public int insertProRouteProcess(ProRouteProcess proRouteProcess);

    /**
     * 修改工艺组成
     *
     * @param proRouteProcess 工艺组成
     * @return 结果
     */
    public int updateProRouteProcess(ProRouteProcess proRouteProcess);

    /**
     * 删除工艺组成
     *
     * @param recordId 工艺组成主键
     * @return 结果
     */
    public int deleteProRouteProcessByRecordId(Long recordId);

    /**
     * 批量删除工艺组成
     *
     * @param recordIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProRouteProcessByRecordIds(Long[] recordIds);

    /**
     * 根据工艺路线ID删除所有工序配置
     *
     * @param routeId
     * @return
     */
    public int deleteByRouteId(Long routeId);

    ProRouteProcess selectProRouteProcessByRouteIdAndProcessId(@Param("routeId") Long routeId, @Param("processId") Long processId);

    @Select("select prp.process_id,prp.order_num from pro_workorder pw left join pro_route_process prp on pw.route_id = prp.route_id where pw.workorder_id =#{workorderId} and prp.process_id = #{processId}")
    ProRouteProcess selectOrderRouteProcess(@Param("workorderId") Long workorderId, @Param("processId") Long processId);
}
