package com.ximai.mes.pro.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.TreeEntity;
import com.ximai.common.utils.excel.converter.DateTimeConverter;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.domain.vo.ProTaskVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 生产工单对象 pro_workorder
 *
 * @date 2022-05-15
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class ProWorkorderExcelExport  {
    private static final long serialVersionUID = 1L;


    /**
     * 工单编码
     */
    @ExcelProperty("工单编码")
    private String workorderCode;

    private String startSerial;
    private String endSerial;
    /**
     * 工单名称
     */
    @ExcelProperty("工单名称")
    private String workorderName;

    /**
     * 工单类型
     */
    @ExcelProperty("工单类型")
    private String workorderType;

    /**
     * 来源类型
     */
    @ExcelProperty("来源类型")
    private String orderSource;

    /**
     * 来源单据
     */
    @ExcelProperty("来源单据")
    @ApiModelProperty("来源单据")
    private String sourceCode;

    /**
     * 产品ID
     */
    @ExcelProperty("产品ID")
    private Long productId;


    /**
     * 是否急单
     */
    @ExcelProperty("是否急单")
    private String  rushOrder;

    /**
     * 产品编号
     */
    @ExcelProperty("产品编号")
    private String productCode;

    /**
     * 产品名称
     */
    @ExcelProperty("产品名称")
    private String productName;
    /**
     * 规格型号
     */
    @ExcelProperty("规格型号")
    private String productSpc;

    /**
     * 单位
     */
    @ApiModelProperty("单位")
    private String unitOfMeasure;

    /**
     * 编排单号
     */
    @ApiModelProperty("编排单号")
    private String arrangeCode;

    /**
     * 批次号
     */
    @ExcelProperty("批次号")
    private String batchCode;

    /**
     * 生产数量
     */
    @ExcelProperty("生产数量")
    @ApiModelProperty("工单数量")
    private BigDecimal quantity;

    /**
     * 调整数量
     */
    @ExcelProperty("调整数量")
    private BigDecimal quantityChanged;

    /**
     * 客户ID
     */
    @ExcelProperty("客户ID")
    private Long clientId;

    /**
     * 客户编码
     */
    @ExcelProperty("客户编码")
    private String clientCode;

    /**
     * 客户名称
     */
    @ExcelProperty("客户名称")
    private String clientName;

    /**
     * 供应商ID
     */
    @ExcelProperty("供应商ID")
    private Long vendorId;

    /**
     * 供应商编号
     */
    @ExcelProperty("供应商编号")
    private String vendorCode;

    /**
     * 供应商名称
     */
    @ExcelProperty("供应商名称")
    private String vendorName;


    /**
     * 需求日期 -> 完工时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @ExcelProperty(value = "需求日期", converter = DateTimeConverter.class)
    private Date requestDate;

    /**
     * 完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ExcelProperty(value = "完成时间", converter = DateTimeConverter.class, format = "")
    private Date finishDate;

    /**
     * 单据状态
     */
    @ExcelProperty("单据状态")
    private String status;
    /**
     * 工厂编码
     */
    @ExcelProperty("工厂编码")
    private Long factoryCode;

    /**
     * 订单开始日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @ExcelProperty(value = "订单开始日期", converter = DateTimeConverter.class)
    private Date startDate;

    /**
     * 生产主管
     */
    @ExcelProperty("生产主管")
    private String productionManagerId;

    /**
     * 库存地点
     */
    @ExcelProperty("库存地点")
    private String storageLocation;

    /**
     * 派工倍数
     */
    @ExcelProperty("派工倍数")
    private String dispatchMultiple;

    /**
     * 排版行数
     */
    @ExcelProperty("排版行数")
    private String rowNum;

    /**
     * 单重
     */
    @ExcelProperty("单重")
    private BigDecimal singleWeight;

    /**
     * 厚度(丝)
     */
    @ExcelProperty("厚度(丝)")
    private BigDecimal thickness;

    /**
     * 物料清单
     */
    @ExcelProperty("物料清单")
    private String materialsGroupBill;

    /**
     * 备选物料清单
     */
    @ExcelProperty("备选物料清单")
    private String alternativeBill;


}
