package com.ximai.mes.pro.domain.vo;

import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.proWorkOrder.ProWorkorder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 报工数据按订单分配信息
 *
 * @date 2024-03-08
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ProFeedbackSplitInfo {

    public ProFeedbackSplitInfo(BigDecimal quantityQualify, ProWorkorder workorder) {
        this.quantityQualify = quantityQualify;
        this.workorder = workorder;
    }

    BigDecimal quantityQualify;
    BigDecimal quantityUnqualify;
    ProWorkorder workorder;
    Long taskWorkunitId;

    /**
     * 关联报工单，单个工单可以按批次、SIZE一并报工
     */
    List<ProFeedback> feedbackList = new ArrayList<>();
}
