package com.ximai.mes.pro.domain.to;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * title: 生产版本BOM主数据传SAP对象
 * author:ZHT
 * date:2024/2/20
 * description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties
public class ProProductionSolutionBomTo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 工厂
     */
    @JSONField(name = "WERKS", ordinal = 0)
    private String factoryCode;

    /**
     * 备选物料清单
     * 01 02 03
     */
    @JSONField(name = "STLAL", ordinal = 1)
    private String alternativeBill;

    /**
     * 物料清单用途
     * 默认1-生产
     */
    @JSONField(name = "STLAN", ordinal = 2)
    private int usageCode;

    /**
     * 物料编号
     * SAP物料编码
     */
    @JSONField(name = "MATNR", ordinal = 3)
    private String sapItemCode;

    /**
     * 物料描述(非必填)
     */
    @JSONField(name = "MAKTX", ordinal = 4)
    private String itemName;

    /**
     * 基本数量
     */
    @JSONField(name = "BMENG", ordinal = 5)
    private BigDecimal itemQuantity;

    /**
     * 物料清单的基本计量单位(非必填)
     */
    @JSONField(name = "BMEIN", ordinal = 6)
    private String unitOfMeasure;

    /**
     * ECN 变更号(非必填)
     */
    @JSONField(name = "AENNR", ordinal = 7)
    private String ecnCode;

    /**
     * 抬头文本描述
     * 对BOM的描述(非必填)
     */
    @JSONField(name = "ZTEXT", ordinal = 8)
    private String remark;

    /**
     * 从批量
     * 批量范围的上限
     */
    @JSONField(name = "LOSVN", ordinal = 9)
    private BigDecimal maxLot;

    /**
     * 到批量
     * 批量范围的下限
     */
    @JSONField(name = "LOSBS", ordinal = 10)
    private BigDecimal minLot;

    /**
     * 物料清单授权组
     * 配方保密的管控--暂不用
     */
    @JSONField(name = "STLBE", ordinal = 11)
    private String billOfMaterialsAuthorizationGroup;

    /**
     * 更新标识
     * I新建 U更新 D删除
     */
    @JSONField(name = "UPDKZ", ordinal = 12)
    private char updateLog;

    /**
     * 行项目
     */
    @JSONField(name = "item", ordinal = 13)
    private List<ProProductionSolutionBomItemTo> bomItemList;
}
