package com.ximai.mes.pro.domain.sap;

import com.alibaba.fastjson.annotation.JSONField;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;


/**
 * title: 工单主数据TO
 * author:ZHT
 * date:2024/3/1
 * description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
//@JsonIgnoreProperties
public class SAPDtoProWorkOrder extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 工单编码
     */
    @JSONField(name = "AUFNR")
    private String workorderCode;

    /**
     * 工厂编号
     */
    @JSONField(name = "WERKS")
    private String factionCode;


    /**
     * 订单类型 auart
     */
    @JSONField(name = "AUART")
    private String workorderType;


    /**
     * 订单类型 auart
     */
    @JSONField(name = "DAUAT")
    private String workorderTypeV2;

    /**
     * 物料号
     */
    @JSONField(name = "PLNBEZ")
    private String sapItemCode;

    /**
     * ep物料号
     */
    @JSONField(name = "ZEP_MATNR")
    private String epItemCode;


    /**
     * ep物料名称
     */
    @JSONField(name = "MAKTX")
    private String productName;


    /**
     * 判断是否打样工单ZBO2
     */
    @JSONField(name = "MATNR")
    private String epItem;

    /**
     * 生产数量
     */
    @JSONField(name = "GAMNG")
    private BigDecimal quantity;

    /**
     * 计量单位
     */
    @JSONField(name = "GMEIN")
    private String unitOfMeasure;

    /**
     * 工程变更
     */
    @JSONField(name = "NORMT")
    private String ecnCode;

    /**
     * 开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(name = "GLTRP")
    private Date startDate;

    /**
     * 完成时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(name = "GSTRP")
    private Date requestDate;

    /**
     * 生产管理员
     */
    @JSONField(name = "FEVOR")
    private String productionAdministrator;

    /**
     * 库存地点
     */
    @JSONField(name = "LGORT1")
    private String storageLocation;

    /**
     * 批号
     */
    @JSONField(name = "CHARG")
    private String batchNumber;

    /**
     * 工单状态
     */
    @JSONField(name = "ZSTATUS")
    private String status;

    /**
     * 工单文本备注
     */
    @JSONField(name = "ZLONGTEXT")
    private String remark;

    /**
     * 派工倍数
     */
    @JSONField(name = "ZPGBS")
    private String dispatchMultiple;

    /**
     * 排版行数
     */
    @JSONField(name = "ZPBHS")
    private String rowNum;

    /**
     * 单重
     */
    @JSONField(name = "ZDANZ")
    private BigDecimal singleWeight;

    /**
     * 厚度（丝）
     */
    @JSONField(name = "ZDCH")
    private BigDecimal thickness;

    /**
     * 组计数器
     */
    @JSONField(name = "PLNAL")
    private String groupCounter;

    /**
     * 任务清单组键值
     */
    @JSONField(name = "PLNNR")
    private String groupKey;


    /**
     * 物料清单
     */
    @JSONField(name = "STLNR")
    private String materialsGroupBill;

    /**
     * 备选物料清单
     */
    @JSONField(name = "STLAL")
    private String alternativeBill;

    /**
     * 包装数量
     */
    @JSONField(name = "ZPACKREQUNUM")
    private BigDecimal packNum;

    /**
     * 包装类型
     */
    @JSONField(name = "ZPACKREQU")
    private String packType;

    /**
     * 包装单位
     */
    @JSONField(name = "ZPACKUNIT")
    private String packUnitOfMeasure;

    /**
     * LOSS
     */
    @JSONField(name = "ZLOSSPACK")
    private String lossIndividuallyWrap;

    /**
     * 客户编码
     */
    @JSONField(name = "KUNNR")
    private String clientCode;


    /**
     * 客户名称
     */
    @JSONField(name = "KUNNR_TXT")
    private String clientName;

    /** 是否急单 */
    @JSONField(name = "")
    private String  rushOrder;


    /**
     * 指令集合
     */
    @JSONField(name = "SO")
    private List<SAPDtoProWorkOrderSoDirective> saleList;

    /**
     * 工序
     */
    @JSONField(name = "MAPL")
    private List<SAPDtoProWorkOrderProcess> processList;


    /**
     * 工序物料
     */
    @JSONField(name = "RESB")
    private List<SAPDtoProWorkOrderBom> bomList;


    /**
     * 尺码明细动态表
     */
    @JSONField(name = "ZSIZE")
    private List<SAPDtoProWorkOrderSoSizeItem> sizeList;


}
