package com.ximai.mes.pro.domain.productionSolution;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 生产版本工序物料对象 pro_production_solution_process_item
 *
 * @author zht
 * @date 2024-03-05
 */
@ApiModel(description = "生产版本工序物料对象 pro_production_solution_process_item")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProProductionSolutionProcessItem extends BaseEntity {

    private static final long serialVersionUID = -7891791752239626910L;
    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    @TableId(type = IdType.AUTO)
    private Long productionSolutionProcessItemId;

    /**
     * 生产版本工序ID
     */
    @ApiModelProperty(value = "生产版本工序ID", position = 2)
    @Excel(name = "生产版本工序ID")
    private Long productionSolutionProcessId;

    /**
     * BOM 组件
     */
    @ApiModelProperty(value = "BOM 组件", position = 3)
    @Excel(name = "BOM 组件")
    private String sapItemCode;

    /**
     * 物料名称
     */
    @ApiModelProperty(value = "物料名称", position = 4)
    @Excel(name = "物料名称")
    private String sapItemName;

    /**
     * 物料id
     */
    private Long itemId;

    /**
     * 物料清单用途
     */
    @ApiModelProperty(value = "物料清单用途", position = 5)
    @Excel(name = "物料清单用途")
    private String usageCode;

    /**
     * 单位
     */
    @ApiModelProperty(value = "单位", position = 6)
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 副单位
     */
    @ApiModelProperty(value = "副单位", position = 7)
    @Excel(name = "副单位")
    private String deputyUnitOfMeasure;

    /**
     * 主副单位转换比例
     */
    @ApiModelProperty(value = "主副单位转换比例", position = 8)
    @Excel(name = "主副单位转换比例")
    private BigDecimal unitConvert;

    /**
     * 组件数量
     */
    @ApiModelProperty(value = "组件数量", position = 9)
    @Excel(name = "组件数量")
    private BigDecimal quantity;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注", position = 10)
    @Excel(name = "备注")
    private String remark;

    /**
     * BOM 项目号
     */
    @ApiModelProperty(value = "BOM 项目号", position = 11)
    @Excel(name = "BOM 项目号")
    private String idx;

    /**
     * 标识：反冲
     */
    @ApiModelProperty(value = "标识：反冲", position = 12)
    @Excel(name = "标识：反冲")
    private String recoil;

}
