package com.ximai.mes.pro.domain.productionMake;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 量产制作工序对象 pro_production_make_process
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
public class ProProductionMakeProcess extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long productionMakeProcessId;

    /** 量产制作单ID */
    @Excel(name = "量产制作单ID")
    private Long productionMakeId;

    /** 记录ID */
    @Excel(name = "记录ID")
    private Long recordId;

    /** 工作中心 */
    @Excel(name = "工作中心")
    private Long workstationId;

    /** 标准工时 */
    @Excel(name = "标准工时")
    private BigDecimal stdWorkingTime;

    /** 准备时间 */
    @Excel(name = "准备时间")
    private Integer defaultPreTime;

    /** 等待时间 */
    @Excel(name = "等待时间")
    private Integer defaultSufTime;

    /** 关键工序 */
    @Excel(name = "关键工序")
    private String keyFlag;

    /** 是否检验 */
    @Excel(name = "是否检验")
    private String isCheck;

    private String workstationName;

    /** 工序名称 */
    @Excel(name = "工序名称")
    private String processName;

    /** 工序编码 */
    @Excel(name = "工序编码")
    private String processCode;

    private String linkType;
    private String colorCode;

    /** 下一道工序的名称 */
    @Excel(name ="下一道工序的名称")
    private String nextProcessName;


    public void setProductionMakeProcessId(Long productionMakeProcessId)
    {
        this.productionMakeProcessId = productionMakeProcessId;
    }

    public Long getProductionMakeProcessId()
    {
        return productionMakeProcessId;
    }
    public void setProductionMakeId(Long productionMakeId)
    {
        this.productionMakeId = productionMakeId;
    }

    public Long getProductionMakeId()
    {
        return productionMakeId;
    }
    public void setRecordId(Long recordId)
    {
        this.recordId = recordId;
    }

    public Long getRecordId()
    {
        return recordId;
    }
    public void setWorkstationId(Long workstationId)
    {
        this.workstationId = workstationId;
    }

    public Long getWorkstationId()
    {
        return workstationId;
    }
    public void setStdWorkingTime(BigDecimal stdWorkingTime)
    {
        this.stdWorkingTime = stdWorkingTime;
    }

    public BigDecimal getStdWorkingTime()
    {
        return stdWorkingTime;
    }
    public void setDefaultPreTime(Integer defaultPreTime)
    {
        this.defaultPreTime = defaultPreTime;
    }

    public Integer getDefaultPreTime()
    {
        return defaultPreTime;
    }
    public void setDefaultSufTime(Integer defaultSufTime)
    {
        this.defaultSufTime = defaultSufTime;
    }

    public Integer getDefaultSufTime()
    {
        return defaultSufTime;
    }
    public void setKeyFlag(String keyFlag)
    {
        this.keyFlag = keyFlag;
    }

    public String getKeyFlag()
    {
        return keyFlag;
    }
    public void setIsCheck(String isCheck)
    {
        this.isCheck = isCheck;
    }

    public String getIsCheck()
    {
        return isCheck;
    }

    public String getWorkstationName() {
        return workstationName;
    }

    public void setWorkstationName(String workstationName) {
        this.workstationName = workstationName;
    }

    public String getProcessName() {
        return processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessCode() {
        return processCode;
    }

    public void setProcessCode(String processCode) {
        this.processCode = processCode;
    }

    public String getNextProcessName() {
        return nextProcessName;
    }

    public void setNextProcessName(String nextProcessName) {
        this.nextProcessName = nextProcessName;
    }

    public String getLinkType() {
        return linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    public String getColorCode() {
        return colorCode;
    }

    public void setColorCode(String colorCode) {
        this.colorCode = colorCode;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("productionMakeProcessId", getProductionMakeProcessId())
            .append("productionMakeId", getProductionMakeId())
            .append("recordId", getRecordId())
            .append("workstationId", getWorkstationId())
            .append("stdWorkingTime", getStdWorkingTime())
            .append("defaultPreTime", getDefaultPreTime())
            .append("defaultSufTime", getDefaultSufTime())
            .append("keyFlag", getKeyFlag())
            .append("isCheck", getIsCheck())
            .append("remark", getRemark())
            .toString();
    }
}
