package com.ximai.mes.pro.domain.productionMake;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 量产制作BOM对象 pro_production_make_bom
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
public class ProProductionMakeBom extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long bomItemId;

    /** 量产制作单ID */
    @Excel(name = "量产制作单ID")
    private Long productionMakeId;

    /** 物料ID */
    @Excel(name = "物料ID")
    private Long itemId;

    /** 组件数量 */
    @Excel(name = "组件数量")
    private BigDecimal quantity;

    /** 计量单位 */
    @Excel(name = "计量单位")
    private String unitOfMeasure;

    /** 报废百分比 */
    @Excel(name = "报废百分比")
    private BigDecimal scrapPercentage;

    /** 替代组 */
    @Excel(name = "替代组")
    private String alternativeGroup;

    /** 替代优先级 */
    @Excel(name = "替代优先级")
    private Integer alternativePriorities;

    /** 策略 */
    @Excel(name = "策略")
    private String alternativeStrategy;

    /** 使用概率 */
    @Excel(name = "使用概率")
    private BigDecimal alternativeProbability;

    /** BOM行备注 */
    @Excel(name = "BOM行备注")
    private String bomItemRemark;

    /** 物料备注 */
    @Excel(name = "物料备注")
    private String itemRemark;

    private String itemName;

    public void setBomItemId(Long bomItemId)
    {
        this.bomItemId = bomItemId;
    }

    public Long getBomItemId()
    {
        return bomItemId;
    }
    public void setProductionMakeId(Long productionMakeId)
    {
        this.productionMakeId = productionMakeId;
    }

    public Long getProductionMakeId()
    {
        return productionMakeId;
    }
    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }
    public void setQuantity(BigDecimal quantity)
    {
        this.quantity = quantity;
    }

    public BigDecimal getQuantity()
    {
        return quantity;
    }
    public void setUnitOfMeasure(String unitOfMeasure)
    {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getUnitOfMeasure()
    {
        return unitOfMeasure;
    }
    public void setScrapPercentage(BigDecimal scrapPercentage)
    {
        this.scrapPercentage = scrapPercentage;
    }

    public BigDecimal getScrapPercentage()
    {
        return scrapPercentage;
    }
    public void setAlternativeGroup(String alternativeGroup)
    {
        this.alternativeGroup = alternativeGroup;
    }

    public String getAlternativeGroup()
    {
        return alternativeGroup;
    }
    public void setAlternativePriorities(Integer alternativePriorities)
    {
        this.alternativePriorities = alternativePriorities;
    }

    public Integer getAlternativePriorities()
    {
        return alternativePriorities;
    }
    public void setAlternativeStrategy(String alternativeStrategy)
    {
        this.alternativeStrategy = alternativeStrategy;
    }

    public String getAlternativeStrategy()
    {
        return alternativeStrategy;
    }
    public void setAlternativeProbability(BigDecimal alternativeProbability)
    {
        this.alternativeProbability = alternativeProbability;
    }

    public BigDecimal getAlternativeProbability()
    {
        return alternativeProbability;
    }
    public void setBomItemRemark(String bomItemRemark)
    {
        this.bomItemRemark = bomItemRemark;
    }

    public String getBomItemRemark()
    {
        return bomItemRemark;
    }
    public void setItemRemark(String itemRemark)
    {
        this.itemRemark = itemRemark;
    }

    public String getItemRemark()
    {
        return itemRemark;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("bomItemId", getBomItemId())
            .append("productionMakeId", getProductionMakeId())
            .append("itemId", getItemId())
            .append("quantity", getQuantity())
            .append("unitOfMeasure", getUnitOfMeasure())
            .append("scrapPercentage", getScrapPercentage())
            .append("alternativeGroup", getAlternativeGroup())
            .append("alternativePriorities", getAlternativePriorities())
            .append("alternativeStrategy", getAlternativeStrategy())
            .append("alternativeProbability", getAlternativeProbability())
            .append("bomItemRemark", getBomItemRemark())
            .append("itemRemark", getItemRemark())
            .toString();
    }
}
