package com.ximai.mes.pro.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * BOM对象 pro_bom
 *
 * @author zht
 * @date 2024-01-16
 */
public class ProBom extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long bomId;

    /** BOM编码 */
    @Excel(name = "BOM编码")
    private String bomCode;

    /** 产品id */
//    @Excel(name = "产品id")
    private Long itemId;

    /** 产品名称 */
    @Excel(name = "产品名称")
    private String itemName;

    /** 生产用途 */
//    @Excel(name = "生产用途")
    private Long usageId;

    /**
     * 用途名称
     */
    @Excel(name = "生产用途")
    private String usageName;

    /** 基本数量 */
    @Excel(name = "基本数量")
    private BigDecimal quantity;

    /** 基本计量单位 */
    @Excel(name = "基本计量单位")
    private String unitOfMeasure;

    /** 有效期开始 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "有效期开始", width = 30, dateFormat = "yyyy-MM-dd")
    private Date expirationDateStart;

    /** 有效期结束 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "有效期结束", width = 30, dateFormat = "yyyy-MM-dd")
    private Date expirationDateEnd;

    /** ECN编码 */
    @Excel(name = "ECN编码")
    private String ecnCode;

    /** 单层厚 */
    @Excel(name = "单层厚")
    private BigDecimal singleLayerThickness;

    /** 单重 */
    @Excel(name = "单重")
    private BigDecimal singleWeight;

    /** 排版行数 */
    @Excel(name = "排版行数")
    private Long rowNum;

    /** 派工倍数 */
    @Excel(name = "派工倍数")
    private BigDecimal dispatchMultiple;

    /** 是否启用 */
    @Excel(name = "是否启用")
    private String enableFlag;

    public void setBomId(Long bomId)
    {
        this.bomId = bomId;
    }

    public Long getBomId()
    {
        return bomId;
    }
    public void setBomCode(String bomCode)
    {
        this.bomCode = bomCode;
    }

    public String getBomCode()
    {
        return bomCode;
    }
    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }
    public void setUsageId(Long usageId)
    {
        this.usageId = usageId;
    }

    public Long getUsageId()
    {
        return usageId;
    }
    public void setQuantity(BigDecimal quantity)
    {
        this.quantity = quantity;
    }

    public BigDecimal getQuantity()
    {
        return quantity;
    }
    public void setUnitOfMeasure(String unitOfMeasure)
    {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getUnitOfMeasure()
    {
        return unitOfMeasure;
    }
    public void setExpirationDateStart(Date expirationDateStart)
    {
        this.expirationDateStart = expirationDateStart;
    }

    public Date getExpirationDateStart()
    {
        return expirationDateStart;
    }
    public void setExpirationDateEnd(Date expirationDateEnd)
    {
        this.expirationDateEnd = expirationDateEnd;
    }

    public Date getExpirationDateEnd()
    {
        return expirationDateEnd;
    }
    public void setEcnCode(String ecnCode)
    {
        this.ecnCode = ecnCode;
    }

    public String getEcnCode()
    {
        return ecnCode;
    }
    public void setSingleLayerThickness(BigDecimal singleLayerThickness)
    {
        this.singleLayerThickness = singleLayerThickness;
    }

    public BigDecimal getSingleLayerThickness()
    {
        return singleLayerThickness;
    }
    public void setSingleWeight(BigDecimal singleWeight)
    {
        this.singleWeight = singleWeight;
    }

    public BigDecimal getSingleWeight()
    {
        return singleWeight;
    }
    public void setRowNum(Long rowNum)
    {
        this.rowNum = rowNum;
    }

    public Long getRowNum()
    {
        return rowNum;
    }
    public void setDispatchMultiple(BigDecimal dispatchMultiple)
    {
        this.dispatchMultiple = dispatchMultiple;
    }

    public BigDecimal getDispatchMultiple()
    {
        return dispatchMultiple;
    }
    public void setEnableFlag(String enableFlag)
    {
        this.enableFlag = enableFlag;
    }

    public String getEnableFlag()
    {
        return enableFlag;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getUsageName() {
        return usageName;
    }

    public void setUsageName(String usageName) {
        this.usageName = usageName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("bomId", getBomId())
            .append("bomCode", getBomCode())
            .append("itemId", getItemId())
            .append("itemName", getItemName())
            .append("usageId", getUsageId())
            .append("usageName", getUsageName())
            .append("quantity", getQuantity())
            .append("unitOfMeasure", getUnitOfMeasure())
            .append("expirationDateStart", getExpirationDateStart())
            .append("expirationDateEnd", getExpirationDateEnd())
            .append("ecnCode", getEcnCode())
            .append("singleLayerThickness", getSingleLayerThickness())
            .append("singleWeight", getSingleWeight())
            .append("rowNum", getRowNum())
            .append("dispatchMultiple", getDispatchMultiple())
            .append("enableFlag", getEnableFlag())
            .append("remark", getRemark())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
