package com.ximai.mes.pro.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 调拨料申请对象 pro_allocation_material
 *
 * @author generator
 * @date 2024-05-14
 */


@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString
public class ProAllocationMaterial extends BaseEntity {
    private static final long serialVersionUID = 1L;
 
    /**
     * ID
     */
    @TableId
    private Long allocationMaterialId;

    /**
     * 申请单号
     */
    @Excel(name = "调拨申请单号")
    private String applyNo;


    /**
     * 产品编码
     */
    @Excel(name = "产品编码")
    private String sapItemCode;

    /**
     * 产品名称
     */
    @Excel(name = "产品名称")
    private String itemName;

    /**
     * 工作中心
     */
    @Excel(name = "工作中心")
    private Long workstationId;

    /**
     * 工作中心编码
     */
    @Excel(name = "工作中心编码")
    private String workstationCode;

    /**
     * 领料类型
     */
    @Excel(name = "领料类型")
    private Long materialType;


    /**
     * 工作中心名称
     */
    @TableField(exist = false)
    private String workstationName;
    /**
     * 任务单号
     */
    @Excel(name = "任务单号")
    private Long taskId;

    /**
     * 派工记录ID
     */
    @Excel(name = "派工记录ID")
    private Long taskWorkunitId;


    /**
     * 创建方式
     */
    @Excel(name = "创建方式")
    private Long buildMethod;

    /**
     * 工作中心编码
     */
    @Excel(name = "工作中心编码")
    private String workunitCode;


    /**
     * 工作中心编码
     */
    @Excel(name = "工作中心编码")
    private String workunitName;


    /**
     * 任务单编码
     */
    @Excel(name = "任务单编码")
    private String taskCode;

    /**
     * 申请数量
     */
    @Excel(name = "申请数量")
    private BigDecimal applyNum;

    /**
     * 已调拨料
     */
    @Excel(name = "已调拨料")
    private BigDecimal allocationNum;

    /**
     * 是的结案
     */
    @Excel(name = "是的结案")
    private String windCase;

    /**
     * 需求日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
     * 需求日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /**
     * 预留字段1
     */
    @Excel(name = "预留字段1")
    private String attr1;

    /**
     *是否倒冲
     */
    @TableField(exist = false)
    private String isBackflush;
}
