package com.ximai.mes.pro.controller.prototypeRequest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.pro.domain.vo.ProPrototypeRequestProcessVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestProcess;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestProcessService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 打样申请工序Controller
 *
 * @author zht
 * @date 2024-01-18
 */
@RestController
@RequestMapping("/mes/pro/PrototypeRequestProcess")
public class ProPrototypeRequestProcessController extends BaseController
{
    @Autowired
    private IProPrototypeRequestProcessService proPrototypeRequestProcessService;

    /**
     * 查询打样申请工序列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:PrototypeRequestProcess:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPrototypeRequestProcess proPrototypeRequestProcess)
    {
        startPage();
        List<ProPrototypeRequestProcessVo> list = proPrototypeRequestProcessService.selectProPrototypeRequestProcessList(proPrototypeRequestProcess);
        return getDataTable(list);
    }

    /**
     * 获取打样申请工序详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:PrototypeRequestProcess:query')")
    @GetMapping(value = "/{prototypeRequestProcessId}")
    public AjaxResult getInfo(@PathVariable("prototypeRequestProcessId") Long prototypeRequestProcessId)
    {
        return AjaxResult.success(proPrototypeRequestProcessService.selectProPrototypeRequestProcessByPrototypeRequestProcessId(prototypeRequestProcessId));
    }

    /**
     * 新增打样申请工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:PrototypeRequestProcess:add')")
    @Log(title = "打样申请工序", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPrototypeRequestProcess proPrototypeRequestProcess)
    {
        return toAjax(proPrototypeRequestProcessService.insertProPrototypeRequestProcess(proPrototypeRequestProcess));
    }

    /**
     * 修改打样申请工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:PrototypeRequestProcess:edit')")
    @Log(title = "打样申请工序", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPrototypeRequestProcess proPrototypeRequestProcess)
    {
        return toAjax(proPrototypeRequestProcessService.updateProPrototypeRequestProcess(proPrototypeRequestProcess));
    }

    /**
     * 删除打样申请工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:PrototypeRequestProcess:remove')")
    @Log(title = "打样申请工序", businessType = BusinessType.DELETE)
	@DeleteMapping("/{prototypeRequestProcessIds}")
    public AjaxResult remove(@PathVariable Long[] prototypeRequestProcessIds)
    {
        return toAjax(proPrototypeRequestProcessService.deleteProPrototypeRequestProcessByPrototypeRequestProcessIds(prototypeRequestProcessIds));
    }
}
