package com.ximai.mes.pro.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.AppConfig;
import com.ximai.mes.pro.service.IAppConfigService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.query.Param;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 作业端配置记录Controller
 *
 * @author generator
 * @date 2024-06-24
 */
@RestController
@RequestMapping("/md/appconfig")
public class AppConfigController extends BaseController {
    @Autowired
    private IAppConfigService appConfigService;

    /**
     * 查询作业端配置记录列表
     */
    @PreAuthorize("@ss.hasPermi('md:config:list')")
    @GetMapping("/list")
    @ApiOperation("查询上传APP列表")
    public TableDataInfo list(AppConfig appConfig) {
        startPage();
        List<AppConfig> list = appConfigService.selectAppConfigList(appConfig);
        return getDataTable(list);
    }


    /**
     * 获取作业端配置记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:config:query')")
    @GetMapping(value = "/{id}")
    @ApiOperation("查询上传APP详情")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(appConfigService.selectAppConfigById(id));
    }

    /**
     * 获取作业端配置记录详细信息
     */
    @ApiOperation("获取作业端最新版本")
    @GetMapping(value = "/getVersion")
    public AjaxResult getVersion(@Param("appName") String appName) {
        return AjaxResult.success(appConfigService.selectLastVersion(appName));
    }

    /**
     * 新增作业端配置记录
     */
    @ApiOperation("新增APP更新包")
    @PreAuthorize("@ss.hasPermi('md:config:add')")
    @Log(title = "作业端配置记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody AppConfig appConfig) {
        return toAjax(appConfigService.insertAppConfig(appConfig));
    }

    /**
     * 修改作业端配置记录
     */
    @ApiOperation("修改APP更新包")
    @PreAuthorize("@ss.hasPermi('md:config:edit')")
    @Log(title = "作业端配置记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody AppConfig appConfig) {
        return toAjax(appConfigService.updateAppConfig(appConfig));
    }

    /**
     * 删除作业端配置记录
     */
    @PreAuthorize("@ss.hasPermi('md:config:remove')")
    @Log(title = "作业端配置记录", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(appConfigService.deleteAppConfigByIds(ids));
    }
}
