package com.ximai.mes.od.vo.sap;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.ximai.mes.od.domain.OdSalesOrder;
import lombok.Data;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @since created by hyy on 2024-01-26
 */
@Data
public class SapSaleOrder {
    /**
     * 销售凭证
     */
    private String VBELN;
    /**
     * 销售凭证类型
     */
    private String AUART;
    /**
     * 销售组织
     */
    private String VKORG;
    /**
     * 分销渠道
     */
    private String VTWEG;
    /**
     * 产品组
     */
    private String SPART;
    /**
     * 订单原因（业务交易原因）
     */
    private String AUGRU;
    /**
     * 销售办事处
     */
    private String VKBUR;
    /**
     * 销售组
     */
    private String VKGRP;
    /**
     * 客户编号
     */
    private String KUNNR;
    /**
     * 客户参考
     */
    private String BSTNK;
    /**
     * 要求的交货日期
     */

    private String VDATU;
    /**
     * 客户参考日期
     */
    private String BSTDK;
    /**
     * 国际贸易条款（第 1 部分）
     */
    private String INCO1;
    /**
     * 国际贸易位置
     */
    private String INCO2;
    /**
     * 付款条件代码
     */
    private String ZTERM;
    /**
     * 记录创建日期
     */
    private String ERDAT;
    /**
     * 备注
     */
    private String LTEXT;
    /**
     * 跟单员
     */
    private String ZKUNR;
    /**
     * 生产发货方式
     */
    private String ZF14;
    /**
     * 条码
     */
    private String ZBARDE;
    /**
     * 申购号
     */
    private String ZPONUM;
    /**
     * 款式
     */
    private String ZSTYLE;
    /**
     * OSP订单号
     */
    private String ZOSP;
    /**
     * 交货冻结
     */
    private String LIFSK;
    /**
     * 开票冻结
     */
    private String FAKSK;
    /**
     * 更新标识
     */
    private String UPDKZ;

    private List<SapSaleOrderDetail> ITEM;


    public static SapSaleOrder buildSapSaleOrder(OdSalesOrder odSalesOrder, String flag) {
        flag = flag == null ? "I" : flag;
        final SapSaleOrder sapSaleOrder = new SapSaleOrder();
        sapSaleOrder.setVBELN(odSalesOrder.getOrderNo());
        sapSaleOrder.setAUART(odSalesOrder.getTypeNo());
        sapSaleOrder.setVKORG(odSalesOrder.getOrgNo());
        sapSaleOrder.setVTWEG(odSalesOrder.getChannelNo());
        sapSaleOrder.setSPART(odSalesOrder.getGroupNo());
        sapSaleOrder.setAUGRU(odSalesOrder.getReasonNo());
        sapSaleOrder.setVKBUR(odSalesOrder.getAgencyNo());
        sapSaleOrder.setVKGRP(odSalesOrder.getGroupNo());
        sapSaleOrder.setKUNNR(odSalesOrder.getSapClientCode());
        sapSaleOrder.setBSTNK(odSalesOrder.getPoPurchaseNo());
        sapSaleOrder.setVDATU(DateUtil.format(odSalesOrder.getDeliveryDate(), DatePattern.PURE_DATE_PATTERN));
        sapSaleOrder.setBSTDK(DateUtil.format(odSalesOrder.getPurchaseDate(), DatePattern.PURE_DATE_PATTERN));
        sapSaleOrder.setINCO1(odSalesOrder.getClauseNo());
        sapSaleOrder.setINCO2(odSalesOrder.getClauseAddr());
        sapSaleOrder.setZTERM(odSalesOrder.getPaymentClause());
        sapSaleOrder.setERDAT(DateUtil.format(odSalesOrder.getCreateTime(), DatePattern.PURE_DATE_PATTERN));
        sapSaleOrder.setLTEXT(odSalesOrder.getRemark());
        sapSaleOrder.setZKUNR(odSalesOrder.getMerchandiser());
        sapSaleOrder.setZF14(odSalesOrder.getDespatchType());
        sapSaleOrder.setZBARDE(odSalesOrder.getBarCode());
        sapSaleOrder.setZPONUM(odSalesOrder.getPoPurchaseNo());
        sapSaleOrder.setZSTYLE(odSalesOrder.getCustom());
        sapSaleOrder.setZOSP(odSalesOrder.getOspNo());
        sapSaleOrder.setLIFSK(null);
        sapSaleOrder.setFAKSK(null);
        sapSaleOrder.setUPDKZ(flag);
        sapSaleOrder.setITEM(odSalesOrder.getDetailList().stream()
                .map(SapSaleOrderDetail::buildSapSaleOrderDetail).collect(Collectors.toList()));

        return sapSaleOrder;
    }

}
