package com.ximai.mes.od.service;


import com.ximai.mes.od.domain.OdSalesOrderProductDetail;

import java.util.List;

/**
 * 销售订单产品详情Service接口
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public interface IOdSalesOrderProductDetailService {
    /**
     * 查询销售订单产品详情
     *
     * @param id 销售订单产品详情主键
     * @return 销售订单产品详情
     */
    OdSalesOrderProductDetail selectOdSalesOrderProductDetailById(String id);

    /**
     * 查询销售订单产品详情列表
     *
     * @param odSalesOrderProductDetail 销售订单产品详情
     * @return 销售订单产品详情集合
     */
    List<OdSalesOrderProductDetail> selectOdSalesOrderProductDetailList(OdSalesOrderProductDetail odSalesOrderProductDetail);

    /**
     * 新增销售订单产品详情
     *
     * @param odSalesOrderProductDetail 销售订单产品详情
     * @return 结果
     */
    int insertOdSalesOrderProductDetail(OdSalesOrderProductDetail odSalesOrderProductDetail);

    /**
     * 修改销售订单产品详情
     *
     * @param odSalesOrderProductDetail 销售订单产品详情
     * @return 结果
     */
    int updateOdSalesOrderProductDetail(OdSalesOrderProductDetail odSalesOrderProductDetail);

    /**
     * 批量删除销售订单产品详情
     *
     * @param ids 需要删除的销售订单产品详情主键集合
     * @return 结果
     */
    int deleteOdSalesOrderProductDetailByIds(String[] ids);

    /**
     * 删除销售订单产品详情信息
     *
     * @param id 销售订单产品详情主键
     * @return 结果
     */
    int deleteOdSalesOrderProductDetailById(String id);
}
