package com.ximai.mes.od.mapper;

import com.ximai.mes.od.domain.OdPurchaseOrderDetail;

import java.util.List;

/**
 * 客户采购订单Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
public interface OdPurchaseOrderDetailMapper {
    /**
     * 查询客户采购订单
     *
     * @param id 客户采购订单主键
     * @return 客户采购订单
     */
    OdPurchaseOrderDetail selectOdPurchaseOrderDetailById(String id);

    /**
     * 查询客户采购订单列表
     *
     * @param odPurchaseOrderDetail 客户采购订单
     * @return 客户采购订单集合
     */
    List<OdPurchaseOrderDetail> selectOdPurchaseOrderDetailList(OdPurchaseOrderDetail odPurchaseOrderDetail);

    /**
     * 新增客户采购订单
     *
     * @param odPurchaseOrderDetail 客户采购订单
     * @return 结果
     */
    int insertOdPurchaseOrderDetail(OdPurchaseOrderDetail odPurchaseOrderDetail);


    int batchInsert(List<OdPurchaseOrderDetail> list);

    /**
     * 修改客户采购订单
     *
     * @param odPurchaseOrderDetail 客户采购订单
     * @return 结果
     */
    int updateOdPurchaseOrderDetail(OdPurchaseOrderDetail odPurchaseOrderDetail);

    /**
     * 删除客户采购订单
     *
     * @param id 客户采购订单主键
     * @return 结果
     */
    int deleteOdPurchaseOrderDetailById(String id);

    /**
     * 批量删除客户采购订单
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteOdPurchaseOrderDetailByIds(String[] ids);
}
