package com.ximai.mes.md.service.impl;

import java.util.List;

import cn.hutool.core.collection.CollUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.service.IMdUnitMeasureService;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.md.vo.MdUnitMeasureVo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdUnitMeasureMapper;
import com.ximai.mes.md.domain.MdUnitMeasure;

/**
 * 单位Service业务层处理
 *
 * @date 2022-04-27
 */
@Service
public class MdUnitMeasureServiceImpl implements IMdUnitMeasureService
{
    @Autowired
    private MdUnitMeasureMapper mdUnitMeasureMapper;

    /**
     * 查询单位
     *
     * @param measureId 单位主键
     * @return 单位
     */
    @Override
    public MdUnitMeasure selectMdUnitMeasureByMeasureId(Long measureId)
    {
        return mdUnitMeasureMapper.selectMdUnitMeasureByMeasureId(measureId);
    }

    /**
     * 查询单位
     * @param measureName 单位名称
     * @return
     */
    @Override
    public MdUnitMeasure selectMdUnitMeasureByMeasureName(String measureName) {

        return  mdUnitMeasureMapper.selectMdUnitMeasureByMeasureName(measureName);
    }

    /**
     * 查询单位列表
     *
     * @param mdUnitMeasure 单位
     * @return 单位
     */
    @Override
    public List<MdUnitMeasure> selectMdUnitMeasureList(MdUnitMeasure mdUnitMeasure)
    {
        return mdUnitMeasureMapper.selectMdUnitMeasureList(mdUnitMeasure);
    }

    /**
     * 新增单位
     *
     * @param mdUnitMeasure 单位
     * @return 结果
     */
    @Override
    public int insertMdUnitMeasure(MdUnitMeasure mdUnitMeasure)
    {
        mdUnitMeasure.setCreateTime(DateUtils.getNowDate());
        return mdUnitMeasureMapper.insertMdUnitMeasure(mdUnitMeasure);
    }

    /**
     * 修改单位
     *
     * @param mdUnitMeasure 单位
     * @return 结果
     */
    @Override
    public int updateMdUnitMeasure(MdUnitMeasure mdUnitMeasure)
    {
        mdUnitMeasure.setUpdateTime(DateUtils.getNowDate());
        return mdUnitMeasureMapper.updateMdUnitMeasure(mdUnitMeasure);
    }

    /**
     * 批量删除单位
     *
     * @param measureIds 需要删除的单位主键
     * @return 结果
     */
    @Override
    public int deleteMdUnitMeasureByMeasureIds(Long[] measureIds)
    {
        return mdUnitMeasureMapper.deleteMdUnitMeasureByMeasureIds(measureIds);
    }

    /**
     * 删除单位信息
     *
     * @param measureId 单位主键
     * @return 结果
     */
    @Override
    public int deleteMdUnitMeasureByMeasureId(Long measureId)
    {
        return mdUnitMeasureMapper.deleteMdUnitMeasureByMeasureId(measureId);
    }

    @Override
    public void insertSapSynMdUnitMeasure(List<MdUnitMeasureVo> mdUnitMeasureVos) {
        for (MdUnitMeasureVo md:mdUnitMeasureVos){
            MdUnitMeasure mdUnitMeasure = new MdUnitMeasure();
            BeanUtils.copyProperties(md,mdUnitMeasure);
            MdUnitMeasure mdUnitMeasure1 = new MdUnitMeasure();
            mdUnitMeasure1.setMeasureCode(mdUnitMeasure.getMeasureCode());
            List<MdUnitMeasure> mdUnit = mdUnitMeasureMapper.selectMdUnitMeasureList(mdUnitMeasure1);
           if(CollUtil.isEmpty(mdUnit)){
               if(StringUtils.isEmpty(mdUnitMeasure.getMeasureName())){
                   mdUnitMeasure.setMeasureName(" ");
               }
               mdUnitMeasure.setPrimaryFlag("Y");
               mdUnitMeasure.setEnableFlag("Y");
               insertMdUnitMeasure(mdUnitMeasure);
               continue;
           }else {
               for (MdUnitMeasure m:mdUnit){
                   if(m.getMeasureName().equals(mdUnitMeasure.getMeasureName())){
                       mdUnitMeasure.setPrimaryFlag("Y");
                       mdUnitMeasure.setEnableFlag("Y");
                       mdUnitMeasure.setMeasureId(m.getMeasureId());
                       updateMdUnitMeasure(mdUnitMeasure);
                       continue;
                   }
               }
           }


        }
    }
}
