package com.ximai.mes.md.service.impl;

import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.md.domain.MdSapDict;
import com.ximai.mes.md.mapper.MdSapDictMapper;
import com.ximai.mes.md.service.IMdSapDictService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * sap特性字典Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@Service
public class MdSapDictServiceImpl implements IMdSapDictService {
    @Autowired
    private MdSapDictMapper mdSapDictMapper;

    /**
     * 查询sap特性字典
     *
     * @param id sap特性字典主键
     * @return sap特性字典
     */
    @Override
    public MdSapDict selectById(String id) {
        return mdSapDictMapper.selectSapDictById(id);
    }

    /**
     * 查询sap特性字典列表
     *
     * @param mdSapDict sap特性字典
     * @return sap特性字典
     */
    @Override
    public List<MdSapDict> selectList(MdSapDict mdSapDict) {
        return mdSapDictMapper.selectSapDictList(mdSapDict);
    }

    /**
     * 新增sap特性字典
     *
     * @param mdSapDict sap特性字典
     * @return 结果
     */
    @Override
    public int insert(MdSapDict mdSapDict) {
        mdSapDict.setCreateTime(DateUtils.getNowDate());
        return mdSapDictMapper.insertSapDict(mdSapDict);
    }

    /**
     * 修改sap特性字典
     *
     * @param mdSapDict sap特性字典
     * @return 结果
     */
    @Override
    public int update(MdSapDict mdSapDict) {
        mdSapDict.setUpdateTime(DateUtils.getNowDate());
        return mdSapDictMapper.updateSapDict(mdSapDict);
    }

    /**
     * 批量删除sap特性字典
     *
     * @param ids 需要删除的sap特性字典主键
     * @return 结果
     */
    @Override
    public int deleteByIds(String[] ids) {
        return mdSapDictMapper.deleteSapDictByIds(ids);
    }

    /**
     * 删除sap特性字典信息
     *
     * @param id sap特性字典主键
     * @return 结果
     */
    @Override
    public int deleteById(String id) {
        return mdSapDictMapper.deleteSapDictById(id);
    }
}
